/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.Record;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class CreateTTLTest
extends ClientBase {
    private TestableZooKeeper zk;
    private static final Collection<String> disabledTests = Collections.singleton("testDisabled");

    @Override
    public void setUp() throws Exception {
        System.setProperty("zookeeper.extendedTypesEnabled", disabledTests.contains(this.getTestName()) ? "false" : "true");
        super.setUpWithServerId(254);
        this.zk = this.createClient();
    }

    @Override
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.extendedTypesEnabled");
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testCreate() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, stat, 100L);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test
    public void testBadTTLs() throws InterruptedException, KeeperException {
        RequestHeader h = new RequestHeader(1, 21);
        String path = "/bad_ttl";
        CreateTTLRequest request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), -100L);
        CreateResponse response = new CreateResponse();
        ReplyHeader r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assert.assertEquals((String)"An invalid CreateTTLRequest should throw BadArguments", (long)r.getErr(), (long)KeeperException.Code.BADARGUMENTS.intValue());
        Assert.assertNull((String)"An invalid CreateTTLRequest should not result in znode creation", (Object)this.zk.exists(path, false));
        request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), EphemeralType.TTL.maxValue() + 1L);
        response = new CreateResponse();
        r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assert.assertEquals((String)"An invalid CreateTTLRequest should throw BadArguments", (long)r.getErr(), (long)KeeperException.Code.BADARGUMENTS.intValue());
        Assert.assertNull((String)"An invalid CreateTTLRequest should not result in znode creation", (Object)this.zk.exists(path, false));
    }

    @Test
    public void testMaxTTLs() throws InterruptedException, KeeperException {
        RequestHeader h = new RequestHeader(1, 21);
        String path = "/bad_ttl";
        CreateTTLRequest request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), EphemeralType.TTL.maxValue());
        CreateResponse response = new CreateResponse();
        ReplyHeader r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assert.assertEquals((String)"EphemeralType.getMaxTTL() should succeed", (long)r.getErr(), (long)KeeperException.Code.OK.intValue());
        Assert.assertNotNull((String)"Node should exist", (Object)this.zk.exists(path, false));
    }

    @Test
    public void testCreateSequential() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        String path = this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, stat, 100L);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists(path, false));
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists(path, false));
    }

    @Test
    public void testCreateAsync() throws KeeperException, InterruptedException {
        AsyncCallback.Create2Callback callback = new AsyncCallback.Create2Callback(){

            public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
            }
        };
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, callback, null, 100L);
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test
    public void testModifying() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, stat, 100L);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        for (int i = 0; i < 10; ++i) {
            fakeElapsed.set(50L);
            this.zk.setData("/foo", new byte[i + 1], -1);
            containerManager.checkContainers();
            Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        }
        fakeElapsed.set(200L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test
    public void testMulti() throws KeeperException, InterruptedException {
        Op createTtl = Op.create((String)"/a", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_WITH_TTL, (long)100L);
        Op createTtlSequential = Op.create((String)"/b", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, (long)200L);
        Op createNonTtl = Op.create((String)"/c", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        List results = this.zk.multi(Arrays.asList(createTtl, createTtlSequential, createNonTtl));
        String sequentialPath = ((OpResult.CreateResult)results.get(1)).getPath();
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"node should not have been deleted yet", (Object)this.zk.exists("/a", false));
        Assert.assertNotNull((String)"node should not have been deleted yet", (Object)this.zk.exists(sequentialPath, false));
        Assert.assertNotNull((String)"node should never be deleted", (Object)this.zk.exists("/c", false));
        fakeElapsed.set(110L);
        containerManager.checkContainers();
        Assert.assertNull((String)"node should have been deleted", (Object)this.zk.exists("/a", false));
        Assert.assertNotNull((String)"node should not have been deleted yet", (Object)this.zk.exists(sequentialPath, false));
        Assert.assertNotNull((String)"node should never be deleted", (Object)this.zk.exists("/c", false));
        fakeElapsed.set(210L);
        containerManager.checkContainers();
        Assert.assertNull((String)"node should have been deleted", (Object)this.zk.exists("/a", false));
        Assert.assertNull((String)"node should have been deleted", (Object)this.zk.exists(sequentialPath, false));
        Assert.assertNotNull((String)"node should never be deleted", (Object)this.zk.exists("/c", false));
    }

    @Test
    public void testBadUsage() throws KeeperException, InterruptedException {
        Op op2;
        for (CreateMode createMode : CreateMode.values()) {
            try {
                this.zk.create("/foo", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode, new Stat(), createMode.isTTL() ? 0L : 100L);
                Assert.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (CreateMode createMode : CreateMode.values()) {
            AsyncCallback.Create2Callback callback = new AsyncCallback.Create2Callback(){

                public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
                }
            };
            try {
                this.zk.create("/foo", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode, callback, null, createMode.isTTL() ? 0L : 100L);
                Assert.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            op2 = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_WITH_TTL, (long)0L);
            this.zk.multi(Collections.singleton(op2));
            Assert.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException op2) {
            // empty catch block
        }
        try {
            op2 = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, (long)0L);
            this.zk.multi(Collections.singleton(op2));
            Assert.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=KeeperException.UnimplementedException.class)
    public void testDisabled() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 100L);
    }

    private ContainerManager newContainerManager(final AtomicLong fakeElapsed) {
        return new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100){

            protected long getElapsed(DataNode node) {
                return fakeElapsed.get();
            }
        };
    }
}

