/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.BitHashSet;
import org.junit.Assert;
import org.junit.Test;

public class BitHashSetTest
extends ZKTestCase {
    @Test
    public void testAddWatchBit() {
        int bit;
        int watcherCacheSize = 1;
        BitHashSet ws = new BitHashSet(watcherCacheSize);
        Assert.assertTrue((boolean)ws.add(Integer.valueOf(1)));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        ArrayList<Integer> actualBits = new ArrayList<Integer>();
        Iterator iterator = ws.iterator();
        while (iterator.hasNext()) {
            bit = (Integer)iterator.next();
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{1}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        Assert.assertFalse((boolean)ws.add(Integer.valueOf(1)));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        Assert.assertTrue((boolean)ws.add(Integer.valueOf(2)));
        Assert.assertEquals((long)2L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        Assert.assertTrue((boolean)ws.contains(Integer.valueOf(1)));
        actualBits.clear();
        iterator = ws.iterator();
        while (iterator.hasNext()) {
            bit = (Integer)iterator.next();
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
    }

    @Test
    public void testRemoveWatchBit() {
        int bit;
        int watcherCacheSize = 1;
        BitHashSet ws = new BitHashSet(watcherCacheSize);
        ws.add(Integer.valueOf(1));
        ws.add(Integer.valueOf(2));
        Assert.assertTrue((boolean)ws.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)ws.contains(Integer.valueOf(2)));
        ws.remove(Integer.valueOf(1));
        Assert.assertFalse((boolean)ws.contains(Integer.valueOf(1)));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)0L, (long)ws.cachedSize());
        ArrayList<Integer> actualBits = new ArrayList<Integer>();
        Iterator iterator = ws.iterator();
        while (iterator.hasNext()) {
            bit = (Integer)iterator.next();
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{2}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        ws.add(Integer.valueOf(3));
        Assert.assertEquals((long)2L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        actualBits.clear();
        iterator = ws.iterator();
        while (iterator.hasNext()) {
            bit = (Integer)iterator.next();
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{2, 3}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        ws.remove(Integer.valueOf(2));
        ws.remove(Integer.valueOf(3));
        Assert.assertEquals((long)0L, (long)ws.size());
        Assert.assertEquals((long)0L, (long)ws.cachedSize());
    }
}

