/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.TypeClass;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.processor.source.feature.Feature;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

public abstract class Type
extends ValueType
implements Excerpt {
    public static Type from(DeclaredType declaredType) {
        if (declaredType.getTypeArguments().isEmpty()) {
            return new TypeClass(QualifiedName.of(ModelUtils.asElement(declaredType)), ImmutableList.of());
        }
        return new TypeImpl(QualifiedName.of(ModelUtils.asElement(declaredType)), declaredType.getTypeArguments());
    }

    public static Type from(Class<?> cls) {
        return new TypeImpl(QualifiedName.of(cls), Arrays.asList(cls.getTypeParameters()));
    }

    public abstract QualifiedName getQualifiedName();

    protected abstract List<?> getTypeParameters();

    public String getSimpleName() {
        return this.getQualifiedName().getSimpleName();
    }

    public boolean isParameterized() {
        return !this.getTypeParameters().isEmpty();
    }

    public Excerpt constructor() {
        return Excerpts.add("new %s%s", this.getQualifiedName(), this.diamondOperator());
    }

    public JavadocLink javadocLink() {
        return new JavadocLink("%s", this.getQualifiedName());
    }

    public JavadocLink javadocNoArgMethodLink(String memberName) {
        return new JavadocLink("%s#%s()", this.getQualifiedName(), memberName);
    }

    public JavadocLink javadocMethodLink(String memberName, Type ... types) {
        return new JavadocLink("%s#%s(%s)", this.getQualifiedName(), memberName, code -> {
            String separator = "";
            for (Type type : types) {
                code.add("%s%s", separator, type.getQualifiedName());
                separator = ", ";
            }
        });
    }

    public Excerpt typeParameters() {
        if (this.getTypeParameters().isEmpty()) {
            return Excerpts.EMPTY;
        }
        return Excerpts.add("<%s>", Excerpts.join(", ", this.getTypeParameters()));
    }

    public Excerpt diamondOperator() {
        return this.isParameterized() ? Excerpts.add("<>", new Object[0]) : Excerpts.EMPTY;
    }

    public Type withWildcards() {
        if (this.getTypeParameters().isEmpty()) {
            return this;
        }
        return new TypeImpl(this.getQualifiedName(), Collections.nCopies(this.getTypeParameters().size(), "?"));
    }

    @Override
    public void addTo(SourceBuilder source) {
        source.add("%s%s", this.getQualifiedName(), this.typeParameters());
    }

    static class TypeImpl
    extends Type {
        private final QualifiedName qualifiedName;
        private final List<?> typeParameters;

        TypeImpl(QualifiedName qualifiedName, List<?> typeParameters) {
            this.qualifiedName = Preconditions.checkNotNull(qualifiedName);
            this.typeParameters = ImmutableList.copyOf(typeParameters);
        }

        @Override
        public QualifiedName getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        protected List<?> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("qualifiedName", this.qualifiedName);
            fields.add("typeParameters", this.typeParameters);
        }

        @Override
        public String toString() {
            return SourceBuilder.forTesting(new Feature[0]).add(this).toString();
        }
    }

    public static class JavadocLink
    implements Excerpt {
        private final String fmt;
        private final Object[] args;

        public JavadocLink(String fmt, Object ... args) {
            this.fmt = fmt;
            this.args = args;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.add("{@link ", new Object[0]).add(this.fmt, this.args).add("}", new Object[0]);
        }

        public Excerpt withText(String fmt, Object ... args) {
            return code -> code.add("{@link ", new Object[0]).add(this.fmt, this.args).add(" ", new Object[0]).add(fmt, args).add("}", new Object[0]);
        }
    }
}

