/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.inferred.freebuilder.shaded.com.google.common.collect.DiscreteDomain;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Range;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Input;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Newlines;

public abstract class InputOutput {
    private ImmutableList<String> lines = ImmutableList.of();
    protected static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers();
    protected final List<Range<Integer>> range0s = new ArrayList<Range<Integer>>();
    protected final List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
    protected final List<Range<Integer>> range1s = new ArrayList<Range<Integer>>();

    protected final void setLines(ImmutableList<String> lines) {
        this.lines = lines;
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    public final String getLine(int lineI) {
        return (String)this.lines.get(lineI);
    }

    private static void addToRanges(List<Range<Integer>> ranges, int i, int k) {
        while (ranges.size() <= i) {
            ranges.add(EMPTY_RANGE);
        }
        Range<Integer> oldValue = ranges.get(i);
        ranges.set(i, Range.closedOpen(oldValue.isEmpty() ? Integer.valueOf(k) : oldValue.lowerEndpoint(), k + 1));
    }

    protected final void computeRanges(List<? extends Input.Tok> toks) {
        int lineI = 0;
        for (Input.Tok tok : toks) {
            String txt = tok.getOriginalText();
            int lineI0 = lineI;
            lineI += Newlines.count(txt);
            int k = tok.getIndex();
            if (k < 0) continue;
            InputOutput.addToRanges(this.range0s, lineI0, k);
            for (int i = lineI0; i <= lineI; ++i) {
                InputOutput.addToRanges(this.ranges, i, k);
            }
            InputOutput.addToRanges(this.range1s, lineI0, k);
        }
    }

    public static Map<Integer, Range<Integer>> makeKToIJ(InputOutput put, int kN) {
        HashMap<Integer, Range<Integer>> map = new HashMap<Integer, Range<Integer>>();
        int ijN = put.getLineCount();
        for (int ij = 0; ij <= ijN; ++ij) {
            Range<Integer> range = put.getRanges(ij).canonical(INTEGERS);
            for (int k = range.lowerEndpoint().intValue(); k < range.upperEndpoint(); ++k) {
                if (map.containsKey(k)) {
                    map.put(k, Range.closedOpen(((Range)map.get(k)).lowerEndpoint(), ij + 1));
                    continue;
                }
                map.put(k, Range.closedOpen(ij, ij + 1));
            }
        }
        return map;
    }

    public final Range<Integer> getRange0s(int lineI) {
        return 0 <= lineI && lineI < this.range0s.size() ? this.range0s.get(lineI) : EMPTY_RANGE;
    }

    public final Range<Integer> getRanges(int lineI) {
        return 0 <= lineI && lineI < this.ranges.size() ? this.ranges.get(lineI) : EMPTY_RANGE;
    }

    public final Range<Integer> getRange1s(int lineI) {
        return 0 <= lineI && lineI < this.range1s.size() ? this.range1s.get(lineI) : EMPTY_RANGE;
    }

    public String toString() {
        return "InputOutput{lines=" + this.lines + ", range0s=" + this.range0s + ", ranges=" + this.ranges + ", range1s=" + this.range1s + '}';
    }
}

