/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.AttributeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.AuthorTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.CommentTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DeprecatedTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocCommentTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocRootTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocTreeVisitor;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.EndElementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.EntityTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ErroneousTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.IdentifierTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.IndexTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.InheritDocTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.LinkTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.LiteralTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ParamTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ReferenceTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ReturnTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.SeeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.SerialDataTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.SerialFieldTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.SerialTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.SinceTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.StartElementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.TextTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ThrowsTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.UnknownBlockTagTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.UnknownInlineTagTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ValueTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.VersionTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Convert;

public class DocPretty
implements DocTreeVisitor<Void, Void> {
    final Writer out;
    int lmargin = 0;
    final String lineSep = System.getProperty("line.separator");

    public DocPretty(Writer out) {
        this.out = out;
    }

    public void print(DocTree tree) throws IOException {
        try {
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                tree.accept(this, null);
            }
        }
        catch (UncheckedIOException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    protected void print(Object s) throws IOException {
        this.out.write(Convert.escapeUnicode(s.toString()));
    }

    public void print(List<? extends DocTree> list) throws IOException {
        for (DocTree docTree : list) {
            this.print(docTree);
        }
    }

    protected void print(List<? extends DocTree> list, String sep) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        boolean first = true;
        for (DocTree docTree : list) {
            if (!first) {
                this.print(sep);
            }
            this.print(docTree);
            first = false;
        }
    }

    protected void println() throws IOException {
        this.out.write(this.lineSep);
    }

    protected void printTagName(DocTree node) throws IOException {
        this.out.write("@");
        this.out.write(node.getKind().tagName);
    }

    @Override
    public Void visitAttribute(AttributeTree node, Void p) {
        try {
            String quote;
            this.print(node.getName());
            switch (node.getValueKind()) {
                case EMPTY: {
                    quote = null;
                    break;
                }
                case UNQUOTED: {
                    quote = "";
                    break;
                }
                case SINGLE: {
                    quote = "'";
                    break;
                }
                case DOUBLE: {
                    quote = "\"";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (quote != null) {
                this.print("=" + quote);
                this.print(node.getValue());
                this.print(quote);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitComment(CommentTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDeprecated(DeprecatedTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getBody().isEmpty()) {
                this.print(" ");
                this.print(node.getBody());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree node, Void p) {
        try {
            List<? extends DocTree> b = node.getFullBody();
            List<? extends DocTree> t = node.getBlockTags();
            this.print(b);
            if (!b.isEmpty() && !t.isEmpty()) {
                this.print("\n");
            }
            this.print(t, "\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDocRoot(DocRootTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitEndElement(EndElementTree node, Void p) {
        try {
            this.print("</");
            this.print(node.getName());
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree node, Void p) {
        try {
            this.print("&");
            this.print(node.getName());
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        try {
            this.print(node.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitIndex(IndexTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print(" ");
            this.print(node.getSearchTerm());
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitInheritDoc(InheritDocTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitLink(LinkTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print(" ");
            this.print(node.getReference());
            if (!node.getLabel().isEmpty()) {
                this.print(" ");
                this.print(node.getLabel());
            }
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            String body = node.getBody().getBody();
            if (!body.isEmpty() && !Character.isWhitespace(body.charAt(0))) {
                this.print(" ");
            }
            this.print(node.getBody());
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitParam(ParamTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            if (node.isTypeParameter()) {
                this.print("<");
            }
            this.print(node.getName());
            if (node.isTypeParameter()) {
                this.print(">");
            }
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitReference(ReferenceTree node, Void p) {
        try {
            this.print(node.getSignature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSee(SeeTree node, Void p) {
        try {
            this.printTagName(node);
            boolean first = true;
            boolean needSep = true;
            for (DocTree docTree : node.getReference()) {
                if (needSep) {
                    this.print(" ");
                }
                needSep = first && docTree instanceof ReferenceTree;
                first = false;
                this.print(docTree);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerial(SerialTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getName());
            this.print(" ");
            this.print(node.getType());
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSince(SinceTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree node, Void p) {
        try {
            this.print("<");
            this.print(node.getName());
            List<? extends DocTree> attrs = node.getAttributes();
            if (!attrs.isEmpty()) {
                this.print(" ");
                this.print(attrs);
                DocTree last = node.getAttributes().get(attrs.size() - 1);
                if (node.isSelfClosing() && last instanceof AttributeTree && ((AttributeTree)last).getValueKind() == AttributeTree.ValueKind.UNQUOTED) {
                    this.print(" ");
                }
            }
            if (node.isSelfClosing()) {
                this.print("/");
            }
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitText(TextTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitThrows(ThrowsTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getExceptionName());
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
        try {
            this.print("@");
            this.print(node.getTagName());
            this.print(" ");
            this.print(node.getContent());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree node, Void p) {
        try {
            this.print("{");
            this.print("@");
            this.print(node.getTagName());
            this.print(" ");
            this.print(node.getContent());
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitValue(ValueTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            if (node.getReference() != null) {
                this.print(" ");
                this.print(node.getReference());
            }
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitVersion(VersionTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitOther(DocTree node, Void p) {
        try {
            this.print("(UNKNOWN: " + node + ")");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException e) {
            super(e.getMessage(), e);
        }
    }
}

