/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.BKAsyncLogReader;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.api.subscription.SubscriptionsStore;
import org.apache.distributedlog.exceptions.LockCancelledException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.lock.LockClosedException;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncReaderLock
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestAsyncReaderLock.class);
    @Rule
    public TestName runtime = new TestName();

    void assertAcquiredFlagsSet(boolean[] acquiredFlags, int endIndex) {
        int i;
        for (i = 0; i < endIndex; ++i) {
            Assert.assertTrue((String)("reader " + i + " should have acquired lock"), (boolean)acquiredFlags[i]);
        }
        for (i = endIndex; i < acquiredFlags.length; ++i) {
            Assert.assertFalse((String)("reader " + i + " should not have acquired lock"), (boolean)acquiredFlags[i]);
        }
    }

    @Test(timeout=60000L)
    public void testReaderLockIfLockPathDoesntExist() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.closeAndComplete();
        CompletableFuture futureReader1 = dlm.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        BKAsyncLogReader reader1 = (BKAsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        Assert.assertEquals((long)0L, (long)record.getSequenceId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        String readLockPath = reader1.readHandler.getReadLockPath();
        Utils.close((AsyncCloseable)reader1);
        NamespaceDriver driver = dlm.getNamespaceDriver();
        ((BKNamespaceDriver)driver).getWriterZKC().get().delete(readLockPath, -1);
        CompletableFuture futureReader2 = dlm.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader2 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader2);
        record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader2.readNext());
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        Assert.assertEquals((long)0L, (long)record.getSequenceId());
        DLMTestUtil.verifyLogRecord((LogRecord)record);
    }

    @Test(timeout=60000L)
    public void testReaderLockCloseInAcquireCallback() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.closeAndComplete();
        CountDownLatch latch = new CountDownLatch(1);
        CompletableFuture futureReader1 = dlm.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        futureReader1.thenCompose(reader -> reader.asyncClose().thenApply(result -> {
            latch.countDown();
            return null;
        }));
        latch.await();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockBackgroundReaderLockAcquire() throws Exception {
        final String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.closeAndComplete();
        CompletableFuture futureReader1 = dlm.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        reader1.readNext();
        final CountDownLatch acquiredLatch = new CountDownLatch(1);
        final AtomicBoolean acquired = new AtomicBoolean(false);
        Thread acquireThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompletableFuture futureReader2 = null;
                BKDistributedLogManager dlm2 = null;
                try {
                    dlm2 = TestAsyncReaderLock.this.createNewDLM(TestDistributedLogBase.conf, name);
                    futureReader2 = dlm2.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
                    AsyncLogReader reader2 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader2);
                    acquired.set(true);
                    acquiredLatch.countDown();
                }
                catch (Exception ex) {
                    Assert.fail((String)"shouldn't reach here");
                }
                finally {
                    try {
                        dlm2.close();
                    }
                    catch (Exception ex) {
                        Assert.fail((String)"shouldn't reach here");
                    }
                }
            }
        }, "acquire-thread");
        acquireThread.start();
        Thread.sleep(1000L);
        Assert.assertEquals((Object)false, (Object)acquired.get());
        Utils.close((AsyncCloseable)reader1);
        acquiredLatch.await();
        Assert.assertEquals((Object)true, (Object)acquired.get());
        dlm.close();
    }

    int countDefined(ArrayList<CompletableFuture<AsyncLogReader>> readers) {
        int done = 0;
        for (CompletableFuture<AsyncLogReader> futureReader : readers) {
            if (!futureReader.isDone()) continue;
            ++done;
        }
        return done;
    }

    @Test(timeout=60000L)
    public void testReaderLockManyLocks() throws Exception {
        int i;
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        int count = 5;
        final CountDownLatch acquiredLatch = new CountDownLatch(count);
        ArrayList<CompletableFuture> readers = new ArrayList<CompletableFuture>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            readers.add(null);
        }
        DistributedLogManager[] dlms = new DistributedLogManager[count];
        for (i = 0; i < count; ++i) {
            dlms[i] = this.createNewDLM(conf, name);
            readers.set(i, dlms[i].getAsyncLogReaderWithLock(DLSN.InitialDLSN));
            ((CompletableFuture)readers.get(i)).whenComplete((BiConsumer)new FutureEventListener<AsyncLogReader>(){

                public void onSuccess(AsyncLogReader reader) {
                    acquiredLatch.countDown();
                    reader.asyncClose();
                }

                public void onFailure(Throwable cause) {
                    Assert.fail((String)"acquire shouldnt have failed");
                }
            });
        }
        acquiredLatch.await();
        for (i = 0; i < count; ++i) {
            dlms[i].close();
        }
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockDlmClosed() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm0 = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm0.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        BKDistributedLogManager dlm1 = this.createNewDLM(conf, name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        BKDistributedLogManager dlm2 = this.createNewDLM(conf, name);
        CompletableFuture futureReader2 = dlm2.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        dlm2.close();
        try {
            Utils.ioResult((CompletableFuture)futureReader2);
            Assert.fail((String)"should have thrown exception!");
        }
        catch (CancellationException cancellationException) {
        }
        catch (LockClosedException lockClosedException) {
        }
        catch (LockCancelledException lockCancelledException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)reader1);
        dlm0.close();
        dlm1.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockSessionExpires() throws Exception {
        String name = this.runtime.getMethodName();
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        Namespace ns0 = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        DistributedLogManager dlm0 = ns0.openLog(name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm0.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        Namespace ns1 = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        DistributedLogManager dlm1 = ns1.openLog(name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        ZooKeeperClientUtils.expireSession(((BKNamespaceDriver)ns1.getNamespaceDriver()).getWriterZKC(), zkServers, 1000);
        boolean success = false;
        try {
            Utils.ioResult((CompletableFuture)reader1.readNext());
            success = true;
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
        if (success) {
            Utils.ioResult((CompletableFuture)reader1.readNext());
        }
        Utils.close((AsyncCloseable)reader1);
        dlm0.close();
        ns0.close();
        dlm1.close();
        ns1.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockFutureCancelledWhileWaiting() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm0 = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm0.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        BKDistributedLogManager dlm1 = this.createNewDLM(conf, name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        BKDistributedLogManager dlm2 = this.createNewDLM(conf, name);
        CompletableFuture futureReader2 = dlm2.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        try {
            futureReader2.cancel(true);
            Utils.ioResult((CompletableFuture)futureReader2);
            Assert.fail((String)"Should fail getting log reader as it is cancelled");
        }
        catch (CancellationException cancellationException) {
        }
        catch (LockClosedException lockClosedException) {
        }
        catch (LockCancelledException lockCancelledException) {
        }
        catch (OwnershipAcquireFailedException ownershipAcquireFailedException) {
            // empty catch block
        }
        futureReader2 = dlm2.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        Utils.close((AsyncCloseable)reader1);
        Utils.ioResult((CompletableFuture)futureReader2);
        dlm0.close();
        dlm1.close();
        dlm2.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockFutureCancelledWhileLocked() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm0 = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm0.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        BKDistributedLogManager dlm1 = this.createNewDLM(conf, name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        Utils.ioResult((CompletableFuture)futureReader1);
        futureReader1.cancel(true);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        Utils.ioResult((CompletableFuture)reader1.readNext());
        dlm0.close();
        dlm1.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockSharedDlmDoesNotConflict() throws Exception {
        String name = this.runtime.getMethodName();
        BKDistributedLogManager dlm0 = this.createNewDLM(conf, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm0.startAsyncLogSegmentNonPartitioned();
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        writer.write(DLMTestUtil.getLogRecordInstance(2L));
        writer.closeAndComplete();
        BKDistributedLogManager dlm1 = this.createNewDLM(conf, name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        CompletableFuture futureReader2 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        Utils.ioResult((CompletableFuture)futureReader1);
        Utils.ioResult((CompletableFuture)futureReader2);
        dlm0.close();
        dlm1.close();
    }

    @Test(timeout=60000L)
    public void testReaderLockMultiReadersScenario() throws Exception {
        LogRecordWithDLSN record;
        int recordCount;
        String name = this.runtime.getMethodName();
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        DistributedLogConfiguration localConf = new DistributedLogConfiguration();
        localConf.addConfiguration((Configuration)conf);
        localConf.setImmediateFlushEnabled(false);
        localConf.setPeriodicFlushFrequencyMilliSeconds(60000);
        localConf.setOutputBufferSize(0);
        localConf.setNumWorkerThreads(2);
        localConf.setLockTimeout(Long.MAX_VALUE);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(localConf).uri(uri).clientId("main").build();
        DistributedLogManager dlm0 = namespace.openLog(name);
        DLMTestUtil.generateCompletedLogSegments(dlm0, localConf, 9L, 100L);
        dlm0.close();
        AtomicReference<DLSN> currentDLSN = new AtomicReference<DLSN>(DLSN.InitialDLSN);
        String clientId1 = "reader1";
        Namespace namespace1 = NamespaceBuilder.newBuilder().conf(localConf).uri(uri).clientId(clientId1).build();
        DistributedLogManager dlm1 = namespace1.openLog(name);
        String clientId2 = "reader2";
        Namespace namespace2 = NamespaceBuilder.newBuilder().conf(localConf).uri(uri).clientId(clientId2).build();
        DistributedLogManager dlm2 = namespace2.openLog(name);
        String clientId3 = "reader3";
        Namespace namespace3 = NamespaceBuilder.newBuilder().conf(localConf).uri(uri).clientId(clientId3).build();
        DistributedLogManager dlm3 = namespace3.openLog(name);
        LOG.info("{} is opening reader on stream {}", (Object)clientId1, (Object)name);
        CompletableFuture futureReader1 = dlm1.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        AsyncLogReader reader1 = (AsyncLogReader)Utils.ioResult((CompletableFuture)futureReader1);
        LOG.info("{} opened reader on stream {}", (Object)clientId1, (Object)name);
        LOG.info("{} is opening reader on stream {}", (Object)clientId2, (Object)name);
        CompletableFuture futureReader2 = dlm2.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        LOG.info("{} is opening reader on stream {}", (Object)clientId3, (Object)name);
        CompletableFuture futureReader3 = dlm3.getAsyncLogReaderWithLock(DLSN.InitialDLSN);
        ExecutorService executorService = Executors.newCachedThreadPool();
        ReadRecordsListener listener2 = new ReadRecordsListener(currentDLSN, clientId2, executorService);
        ReadRecordsListener listener3 = new ReadRecordsListener(currentDLSN, clientId3, executorService);
        futureReader2.whenComplete((BiConsumer)((Object)listener2));
        futureReader3.whenComplete((BiConsumer)((Object)listener3));
        for (recordCount = 0; recordCount < 200; ++recordCount) {
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
            currentDLSN.set(record.getDlsn());
        }
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)listener2.done());
        futureReader2.cancel(true);
        listener2.getLatch().await();
        Assert.assertTrue((boolean)listener2.done());
        Assert.assertTrue((boolean)listener2.failed());
        while (recordCount < 300) {
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
            currentDLSN.set(record.getDlsn());
            ++recordCount;
        }
        Assert.assertFalse((boolean)listener3.done());
        Utils.close((AsyncCloseable)reader1);
        listener3.getLatch().await();
        Assert.assertTrue((boolean)listener3.done());
        Assert.assertFalse((boolean)listener3.failed());
        Assert.assertEquals((Object)new DLSN(3L, 99L, 0L), (Object)currentDLSN.get());
        try {
            Utils.ioResult((CompletableFuture)futureReader2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)((AsyncCloseable)Utils.ioResult((CompletableFuture)futureReader3)));
        dlm1.close();
        namespace1.close();
        dlm2.close();
        namespace2.close();
        dlm3.close();
        namespace3.close();
        executorService.shutdown();
    }

    @Test(timeout=60000L)
    public void testAsyncReadWithSubscriberId() throws Exception {
        String name = "distrlog-asyncread-with-sbuscriber-id";
        String subscriberId = "asyncreader";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setImmediateFlushEnabled(true);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        DLSN readDLSN = DLSN.InitialDLSN;
        int txid = 1;
        for (long i = 0L; i < 3L; ++i) {
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            for (long j = 1L; j <= 10L; ++j) {
                DLSN dlsn = (DLSN)Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getEmptyLogRecordInstance(txid++)));
                if (i != 1L || j != 1L) continue;
                readDLSN = dlsn;
            }
            writer.closeAndComplete();
        }
        BKAsyncLogReader reader0 = (BKAsyncLogReader)Utils.ioResult((CompletableFuture)dlm.getAsyncLogReaderWithLock(subscriberId));
        Assert.assertEquals((Object)DLSN.NonInclusiveLowerBound, (Object)reader0.getStartDLSN());
        long numTxns = 0L;
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader0.readNext());
        while (null != record) {
            DLMTestUtil.verifyEmptyLogRecord((LogRecord)record);
            Assert.assertEquals((long)(++numTxns), (long)record.getTransactionId());
            Assert.assertEquals((long)(record.getTransactionId() - 1L), (long)record.getSequenceId());
            if ((long)(txid - 1) == numTxns) break;
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader0.readNext());
        }
        Assert.assertEquals((long)(txid - 1), (long)numTxns);
        Utils.close((AsyncCloseable)reader0);
        SubscriptionsStore subscriptionsStore = dlm.getSubscriptionsStore();
        Utils.ioResult((CompletableFuture)subscriptionsStore.advanceCommitPosition(subscriberId, readDLSN));
        BKAsyncLogReader reader1 = (BKAsyncLogReader)Utils.ioResult((CompletableFuture)dlm.getAsyncLogReaderWithLock(subscriberId));
        Assert.assertEquals((Object)readDLSN, (Object)reader1.getStartDLSN());
        numTxns = 0L;
        long startTxID = 10L;
        record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
        while (null != record) {
            DLMTestUtil.verifyEmptyLogRecord((LogRecord)record);
            ++numTxns;
            Assert.assertEquals((long)(++startTxID), (long)record.getTransactionId());
            Assert.assertEquals((long)(record.getTransactionId() - 1L), (long)record.getSequenceId());
            if (startTxID == (long)(txid - 1)) break;
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader1.readNext());
        }
        Assert.assertEquals((long)(txid - 1), (long)startTxID);
        Assert.assertEquals((long)20L, (long)numTxns);
        Utils.close((AsyncCloseable)reader1);
        dlm.close();
    }

    static class ReadRecordsListener
    implements FutureEventListener<AsyncLogReader> {
        final AtomicReference<DLSN> currentDLSN;
        final String name;
        final ExecutorService executorService;
        final CountDownLatch latch = new CountDownLatch(1);
        boolean failed = false;

        public ReadRecordsListener(AtomicReference<DLSN> currentDLSN, String name, ExecutorService executorService) {
            this.currentDLSN = currentDLSN;
            this.name = name;
            this.executorService = executorService;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public boolean failed() {
            return this.failed;
        }

        public boolean done() {
            return this.latch.getCount() == 0L;
        }

        public void onSuccess(final AsyncLogReader reader) {
            LOG.info("Reader {} is ready to read entries", (Object)this.name);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    this.readEntries(reader);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readEntries(AsyncLogReader reader) {
            try {
                for (int i = 0; i < 300; ++i) {
                    LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
                    this.currentDLSN.set(record.getDlsn());
                }
            }
            catch (Exception ex) {
                this.failed = true;
            }
            finally {
                this.latch.countDown();
            }
        }

        public void onFailure(Throwable cause) {
            LOG.error("{} failed to open reader", (Object)this.name, (Object)cause);
            this.failed = true;
            this.latch.countDown();
        }
    }
}

