/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.google.common.annotations.VisibleForTesting;
import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.checksum.Crc32cSse42Provider;
import com.scurrilous.circe.crc.Sse42Crc32C;
import com.scurrilous.circe.crc.StandardCrcProvider;
import com.scurrilous.circe.params.CrcParameters;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crc32cLongChecksum {
    private static final Logger log = LoggerFactory.getLogger(Crc32cLongChecksum.class);
    @VisibleForTesting
    static final IncrementalIntHash CRC32C_HASH;

    public static long computeChecksum(ByteBuf payload) {
        int crc = payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C ? CRC32C_HASH.calculate(payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes()) : (payload.hasArray() ? CRC32C_HASH.calculate(payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes()) : CRC32C_HASH.calculate(payload.nioBuffer()));
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long resumeChecksum(long previousChecksum, ByteBuf payload) {
        int crc = (int)previousChecksum;
        crc = payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C ? CRC32C_HASH.resume(crc, payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes()) : (payload.hasArray() ? CRC32C_HASH.resume(crc, payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes()) : CRC32C_HASH.resume(crc, payload.nioBuffer()));
        return (long)crc & 0xFFFFFFFFL;
    }

    static {
        if (Sse42Crc32C.isSupported()) {
            CRC32C_HASH = new Crc32cSse42Provider().getIncrementalInt(CrcParameters.CRC32C);
            if (log.isDebugEnabled()) {
                log.debug("SSE4.2 CRC32C provider initialized");
            }
        } else {
            CRC32C_HASH = new StandardCrcProvider().getIncrementalInt(CrcParameters.CRC32C);
            log.warn("Failed to load Circe JNI library. Falling back to Java based CRC32c provider");
        }
    }
}

