/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.internal.ObjectPool;
import io.grpc.rls.ChildLoadBalancerHelper;
import io.grpc.rls.RlsProtoData;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class LbPolicyConfiguration {
    private final RlsProtoData.RouteLookupConfig routeLookupConfig;
    private final ChildLoadBalancingPolicy policy;

    LbPolicyConfiguration(RlsProtoData.RouteLookupConfig routeLookupConfig, ChildLoadBalancingPolicy policy) {
        this.routeLookupConfig = (RlsProtoData.RouteLookupConfig)Preconditions.checkNotNull((Object)routeLookupConfig, (Object)"routeLookupConfig");
        this.policy = (ChildLoadBalancingPolicy)Preconditions.checkNotNull((Object)policy, (Object)"policy");
    }

    RlsProtoData.RouteLookupConfig getRouteLookupConfig() {
        return this.routeLookupConfig;
    }

    ChildLoadBalancingPolicy getLoadBalancingPolicy() {
        return this.policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LbPolicyConfiguration that = (LbPolicyConfiguration)o;
        return Objects.equals(this.routeLookupConfig, that.routeLookupConfig) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.routeLookupConfig, this.policy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("routeLookupConfig", (Object)this.routeLookupConfig).add("policy", (Object)this.policy).toString();
    }

    static final class InvalidChildPolicyConfigException
    extends Exception {
        private static final long serialVersionUID = 0L;

        InvalidChildPolicyConfigException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class RefCountedChildPolicyWrapper
    implements ObjectPool<ChildPolicyWrapper> {
        private final AtomicLong refCnt = new AtomicLong();
        @Nullable
        private ChildPolicyWrapper childPolicyWrapper;

        private RefCountedChildPolicyWrapper(ChildPolicyWrapper childPolicyWrapper) {
            this.childPolicyWrapper = (ChildPolicyWrapper)Preconditions.checkNotNull((Object)childPolicyWrapper, (Object)"childPolicyWrapper");
        }

        public ChildPolicyWrapper getObject() {
            Preconditions.checkState((!this.isReleased() ? 1 : 0) != 0, (Object)"ChildPolicyWrapper is already released");
            this.refCnt.getAndIncrement();
            return this.childPolicyWrapper;
        }

        @Nullable
        public ChildPolicyWrapper returnObject(Object object) {
            Preconditions.checkState((!this.isReleased() ? 1 : 0) != 0, (Object)"cannot return already released ChildPolicyWrapper, this is possibly a bug.");
            Preconditions.checkState((this.childPolicyWrapper == object ? 1 : 0) != 0, (Object)"returned object doesn't match the pooled childPolicyWrapper");
            long newCnt = this.refCnt.decrementAndGet();
            Preconditions.checkState((newCnt != -1L ? 1 : 0) != 0, (Object)"Cannot return never pooled childPolicyWrapper");
            if (newCnt == 0L) {
                this.childPolicyWrapper = null;
            }
            return null;
        }

        boolean isReleased() {
            return this.childPolicyWrapper == null;
        }

        static RefCountedChildPolicyWrapper of(ChildPolicyWrapper childPolicyWrapper) {
            return new RefCountedChildPolicyWrapper(childPolicyWrapper);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("object", (Object)this.childPolicyWrapper).add("refCnt", this.refCnt.get()).toString();
        }
    }

    static interface ChildLbStatusListener {
        public void onStatusChanged(ConnectivityState var1);
    }

    static final class ChildPolicyWrapper {
        private final String target;
        private final ChildPolicyReportingHelper helper;
        private volatile LoadBalancer.SubchannelPicker picker;
        private ConnectivityState state;

        public ChildPolicyWrapper(String target, ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.target = target;
            this.helper = new ChildPolicyReportingHelper(childLbHelperProvider, childLbStatusListener);
        }

        String getTarget() {
            return this.target;
        }

        LoadBalancer.SubchannelPicker getPicker() {
            return this.picker;
        }

        ChildPolicyReportingHelper getHelper() {
            return this.helper;
        }

        void refreshState() {
            this.helper.updateBalancingState(this.state, this.picker);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("picker", (Object)this.picker).add("state", (Object)this.state).toString();
        }

        final class ChildPolicyReportingHelper
        extends ForwardingLoadBalancerHelper {
            private final ChildLoadBalancerHelper delegate;
            private final ChildLbStatusListener listener;

            ChildPolicyReportingHelper(ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childHelperProvider, ChildLbStatusListener listener) {
                Preconditions.checkNotNull((Object)childHelperProvider, (Object)"childHelperProvider");
                this.delegate = childHelperProvider.forTarget(ChildPolicyWrapper.this.getTarget());
                this.listener = (ChildLbStatusListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            }

            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                ChildPolicyWrapper.this.picker = newPicker;
                ChildPolicyWrapper.this.state = newState;
                super.updateBalancingState(newState, newPicker);
                this.listener.onStatusChanged(newState);
            }
        }
    }

    static final class RefCountedChildPolicyWrapperFactory {
        @VisibleForTesting
        final Map<String, RefCountedChildPolicyWrapper> childPolicyMap = new HashMap<String, RefCountedChildPolicyWrapper>();
        private final ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider;
        private final ChildLbStatusListener childLbStatusListener;

        public RefCountedChildPolicyWrapperFactory(ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.childLbHelperProvider = (ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider)Preconditions.checkNotNull((Object)childLbHelperProvider, (Object)"childLbHelperProvider");
            this.childLbStatusListener = (ChildLbStatusListener)Preconditions.checkNotNull((Object)childLbStatusListener, (Object)"childLbStatusListener");
        }

        ChildPolicyWrapper createOrGet(String target) {
            RefCountedChildPolicyWrapper pooledChildPolicyWrapper = this.childPolicyMap.get(target);
            if (pooledChildPolicyWrapper == null) {
                ChildPolicyWrapper childPolicyWrapper = new ChildPolicyWrapper(target, this.childLbHelperProvider, this.childLbStatusListener);
                pooledChildPolicyWrapper = RefCountedChildPolicyWrapper.of(childPolicyWrapper);
                this.childPolicyMap.put(target, pooledChildPolicyWrapper);
            }
            return pooledChildPolicyWrapper.getObject();
        }

        void release(ChildPolicyWrapper childPolicyWrapper) {
            Preconditions.checkNotNull((Object)childPolicyWrapper, (Object)"childPolicyWrapper");
            String target = childPolicyWrapper.getTarget();
            RefCountedChildPolicyWrapper existing = this.childPolicyMap.get(target);
            Preconditions.checkState((existing != null ? 1 : 0) != 0, (Object)"Cannot access already released object");
            existing.returnObject(childPolicyWrapper);
            if (existing.isReleased()) {
                this.childPolicyMap.remove(target);
            }
        }
    }

    static final class ChildLoadBalancingPolicy {
        private final Map<String, Object> effectiveRawChildPolicy;
        private final LoadBalancerProvider effectiveLbProvider;
        private final String targetFieldName;

        @VisibleForTesting
        ChildLoadBalancingPolicy(String targetFieldName, Map<String, Object> effectiveRawChildPolicy, LoadBalancerProvider effectiveLbProvider) {
            Preconditions.checkArgument((targetFieldName != null && !targetFieldName.isEmpty() ? 1 : 0) != 0, (Object)"targetFieldName cannot be empty or null");
            this.targetFieldName = targetFieldName;
            this.effectiveRawChildPolicy = (Map)Preconditions.checkNotNull(effectiveRawChildPolicy, (Object)"effectiveRawChildPolicy");
            this.effectiveLbProvider = (LoadBalancerProvider)Preconditions.checkNotNull((Object)effectiveLbProvider, (Object)"effectiveLbProvider");
        }

        static ChildLoadBalancingPolicy create(String childPolicyConfigTargetFieldName, List<Map<String, ?>> childPolicies) throws InvalidChildPolicyConfigException {
            Map<String, ?> effectiveChildPolicy = null;
            LoadBalancerProvider effectiveLbProvider = null;
            ArrayList<String> policyTried = new ArrayList<String>();
            LoadBalancerRegistry lbRegistry = LoadBalancerRegistry.getDefaultRegistry();
            for (Map<String, ?> childPolicy : childPolicies) {
                if (childPolicy.isEmpty()) continue;
                if (childPolicy.size() != 1) {
                    throw new InvalidChildPolicyConfigException("childPolicy should have exactly one loadbalancing policy");
                }
                String policyName = childPolicy.keySet().iterator().next();
                LoadBalancerProvider provider = lbRegistry.getProvider(policyName);
                if (provider != null) {
                    effectiveLbProvider = provider;
                    effectiveChildPolicy = Collections.unmodifiableMap(childPolicy);
                    break;
                }
                policyTried.add(policyName);
            }
            if (effectiveChildPolicy == null) {
                throw new InvalidChildPolicyConfigException(String.format("no valid childPolicy found, policy tried: %s", policyTried));
            }
            return new ChildLoadBalancingPolicy(childPolicyConfigTargetFieldName, (Map)effectiveChildPolicy.values().iterator().next(), effectiveLbProvider);
        }

        Map<String, ?> getEffectiveChildPolicy(String target) {
            HashMap<String, Object> childPolicy = new HashMap<String, Object>(this.effectiveRawChildPolicy);
            childPolicy.put(this.targetFieldName, target);
            return childPolicy;
        }

        LoadBalancerProvider getEffectiveLbProvider() {
            return this.effectiveLbProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildLoadBalancingPolicy that = (ChildLoadBalancingPolicy)o;
            return Objects.equals(this.effectiveRawChildPolicy, that.effectiveRawChildPolicy) && Objects.equals(this.effectiveLbProvider, that.effectiveLbProvider) && Objects.equals(this.targetFieldName, that.targetFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.effectiveRawChildPolicy, this.effectiveLbProvider, this.targetFieldName);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("effectiveRawChildPolicy", this.effectiveRawChildPolicy).add("effectiveLbProvider", (Object)this.effectiveLbProvider).add("childPolicyConfigTargetFieldName", (Object)this.targetFieldName).toString();
        }
    }
}

