/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;

class GoAwayConverter {
    GoAwayConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, GoAway obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "debugData": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDebugData(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "errorCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setErrorCode(((Number)member.getValue()).longValue());
                    break;
                }
                case "lastStreamId": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLastStreamId(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(GoAway obj, JsonObject json) {
        GoAwayConverter.toJson(obj, json.getMap());
    }

    static void toJson(GoAway obj, Map<String, Object> json) {
        if (obj.getDebugData() != null) {
            json.put("debugData", Base64.getEncoder().encodeToString(obj.getDebugData().getBytes()));
        }
        json.put("errorCode", obj.getErrorCode());
        json.put("lastStreamId", obj.getLastStreamId());
    }
}

