/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import java.util.regex.Pattern;

class JsonPTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(JsonPTransport.class);
    private static final Pattern CALLBACK_VALIDATION = Pattern.compile("[^a-zA-Z0-9-_.]");

    JsonPTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String jsonpRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/jsonp";
        router.getWithRegex(jsonpRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            String callback;
            if (log.isTraceEnabled()) {
                log.trace((Object)("JsonP, get: " + rc.request().uri()));
            }
            if ((callback = rc.request().getParam("callback")) == null && (callback = rc.request().getParam("c")) == null) {
                rc.response().setStatusCode(500);
                rc.response().end("\"callback\" parameter required\n");
                return;
            }
            if (callback.length() > 32 || CALLBACK_VALIDATION.matcher(callback).find()) {
                rc.response().setStatusCode(500);
                rc.response().end("invalid \"callback\" parameter\n");
                return;
            }
            HttpServerRequest req = rc.request();
            String sessionID = req.params().get("param0");
            SockJSSession session = this.getSession((RoutingContext)rc, options.getSessionTimeout(), options.getHeartbeatInterval(), sessionID, sockHandler);
            session.register(req, new JsonPListener((RoutingContext)rc, session, callback));
        }));
        String jsonpSendRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/jsonp_send";
        router.postWithRegex(jsonpSendRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            String sessionID;
            SockJSSession session;
            if (log.isTraceEnabled()) {
                log.trace((Object)("JsonP, post: " + rc.request().uri()));
            }
            if ((session = (SockJSSession)sessions.get((Object)(sessionID = rc.request().getParam("param0")))) != null && !session.isClosed()) {
                this.handleSend((RoutingContext)rc, session);
            } else {
                rc.response().setStatusCode(404);
                JsonPTransport.setJSESSIONID(options, rc);
                rc.response().end();
            }
        }));
    }

    private void handleSend(RoutingContext rc, SockJSSession session) {
        rc.request().bodyHandler(buff -> {
            boolean urlEncoded;
            String body = buff.toString();
            String ct = rc.request().getHeader("content-type");
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(ct)) {
                urlEncoded = true;
            } else if ("text/plain".equalsIgnoreCase(ct)) {
                urlEncoded = false;
            } else {
                rc.response().setStatusCode(500);
                rc.response().end("Invalid Content-Type");
                return;
            }
            if (body.equals("") || urlEncoded && (!body.startsWith("d=") || body.length() <= 2)) {
                rc.response().setStatusCode(500).end("Payload expected.");
                return;
            }
            if (urlEncoded) {
                body = URIDecoder.decodeURIComponent((String)body, (boolean)true).substring(2);
            }
            if (!session.handleMessages(body)) {
                this.sendInvalidJSON(rc.response());
            } else {
                JsonPTransport.setJSESSIONID(this.options, rc);
                rc.response().putHeader("Content-Type", "text/plain; charset=UTF-8");
                JsonPTransport.setNoCacheHeaders(rc);
                rc.response().end("ok");
                if (log.isTraceEnabled()) {
                    log.trace((Object)"send handled ok");
                }
            }
        });
    }

    private class JsonPListener
    extends BaseTransport.BaseListener {
        final String callback;
        boolean headersWritten;
        boolean closed;

        JsonPListener(RoutingContext rc, SockJSSession session, String callback) {
            super(rc, session);
            this.callback = callback;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"JsonP, sending frame");
            }
            if (!this.headersWritten) {
                this.rc.response().setChunked(true).putHeader("X-Content-Type-Options", "nosniff").putHeader("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.rc);
                BaseTransport.setJSESSIONID(JsonPTransport.this.options, this.rc);
                this.headersWritten = true;
            }
            body = JsonPTransport.this.escapeForJavaScript(body);
            String sb = "/**/" + this.callback + "(\"" + body + "\");\r\n";
            this.rc.response().write(sb, handler);
            this.close();
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

