/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class BitMapTest
extends ZKTestCase {
    @Test
    public void testAddAndRemove() {
        BitMap bitMap = new BitMap();
        String v1 = "v1";
        Integer bit = bitMap.add((Object)v1);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        Assert.assertTrue((bit >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)v1, (Object)bitMap.get(bit.intValue()));
        Assert.assertEquals((Object)bit, (Object)bitMap.getBit((Object)v1));
        Integer newBit = bitMap.add((Object)v1);
        Assert.assertEquals((Object)bit, (Object)newBit);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        String v2 = "v2";
        Integer v2Bit = bitMap.add((Object)v2);
        Assert.assertEquals((long)2L, (long)bitMap.size());
        Assert.assertNotEquals((Object)v2Bit, (Object)bit);
        bitMap.remove((Object)v1);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        Assert.assertNull((Object)bitMap.get(bit.intValue()));
        Assert.assertNull((Object)bitMap.getBit((Object)v1));
        bitMap.remove(v2Bit.intValue());
        Assert.assertEquals((long)0L, (long)bitMap.size());
        Assert.assertNull((Object)bitMap.get(v2Bit.intValue()));
        Assert.assertNull((Object)bitMap.getBit((Object)v2));
    }

    @Test
    public void testBitReuse() {
        BitMap bitMap = new BitMap();
        int v1Bit = bitMap.add((Object)"v1");
        int v2Bit = bitMap.add((Object)"v2");
        int v3Bit = bitMap.add((Object)"v3");
        bitMap.remove(v2Bit);
        int v4Bit = bitMap.add((Object)"v4");
        Assert.assertEquals((long)v4Bit, (long)v2Bit);
    }
}

