/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.service;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.internal.service.InternalEventLoopServiceWrapper;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import net.openhft.chronicle.threads.EventGroup;
import org.jetbrains.annotations.NotNull;

public class InternalServiceWrapperBuilder<O>
implements ServiceWrapper.Builder<O> {
    private final List<String> inputPaths = new ArrayList<String>();
    private final List<Function<O, Object>> serviceFunctions = new ArrayList<Function<O, Object>>();
    private String outputPath;
    private Class<O> outClass;
    private EventLoop eventLoop;
    private HandlerPriority priority = HandlerPriority.MEDIUM;
    private boolean createdEventLoop = false;
    private int inputSourceId;
    private int outputSourceId;
    private final List<ChronicleQueue> queues = new ArrayList<ChronicleQueue>();

    InternalServiceWrapperBuilder() {
    }

    @NotNull
    public static <O> InternalServiceWrapperBuilder<O> serviceBuilder(String inputPath, String outputPath, Class<O> outClass, Function<O, Object> serviceFunction) {
        InternalServiceWrapperBuilder<O> swb = new InternalServiceWrapperBuilder<O>();
        swb.addInputPath(inputPath);
        swb.outputPath = outputPath;
        swb.outClass = outClass;
        swb.addServiceFunction((Function)serviceFunction);
        return swb;
    }

    @Override
    @NotNull
    public List<String> inputPath() {
        return this.inputPaths;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> addInputPath(String inputPath) {
        this.inputPaths.add(inputPath);
        return this;
    }

    @Override
    public Class<O> outClass() {
        return this.outClass;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> outClass(Class<O> outClass) {
        this.outClass = outClass;
        return this;
    }

    @Override
    public String outputPath() {
        return this.outputPath;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @Override
    @NotNull
    public List<Function<O, Object>> getServiceFunctions() {
        return this.serviceFunctions;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> addServiceFunction(Function<O, Object> serviceFunctions) {
        this.serviceFunctions.add(serviceFunctions);
        return this;
    }

    @Override
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public boolean createdEventLoop() {
        return this.createdEventLoop;
    }

    @Override
    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    @Override
    public HandlerPriority priority() {
        return this.priority;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> priority(HandlerPriority priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public int inputSourceId() {
        return this.inputSourceId;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> inputSourceId(int inputSourceId) {
        this.inputSourceId = inputSourceId;
        return this;
    }

    @Override
    public int outputSourceId() {
        return this.outputSourceId;
    }

    @Override
    @NotNull
    public InternalServiceWrapperBuilder<O> outputSourceId(int outputSourceId) {
        this.outputSourceId = outputSourceId;
        return this;
    }

    @Override
    @NotNull
    public ServiceWrapper get() {
        if (this.eventLoop == null) {
            this.eventLoop = new EventGroup(false);
            this.createdEventLoop = true;
        }
        return new InternalEventLoopServiceWrapper(this);
    }

    @Override
    @NotNull
    public ChronicleQueue inputQueue() {
        SingleChronicleQueue build = SingleChronicleQueueBuilder.binary(this.inputPaths.get(0)).sourceId(this.inputSourceId()).checkInterrupts(false).build();
        this.queues.add(build);
        return build;
    }

    @Override
    @NotNull
    public ChronicleQueue outputQueue() {
        SingleChronicleQueue build = SingleChronicleQueueBuilder.binary(this.outputPath).sourceId(this.outputSourceId()).checkInterrupts(false).build();
        this.queues.add(build);
        return build;
    }

    @Override
    @NotNull
    public MethodReader outputReader(Object ... impls) {
        ChronicleQueue queue = this.outputQueue();
        MethodReader reader = queue.createTailer().methodReader(impls);
        reader.closeIn(true);
        return reader;
    }

    @Override
    @NotNull
    public <T> T inputWriter(Class<T> tClass) {
        ChronicleQueue queue = this.inputQueue();
        return queue.acquireAppender().methodWriterBuilder(tClass).recordHistory(true).onClose(queue).get();
    }

    @Override
    public void closeQueues() {
        Closeable.closeQuietly(this.queues);
    }
}

