/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.esotericsoftware.kryo.io.Input;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.complex.CqlCollection;
import org.apache.cassandra.spark.data.complex.CqlFrozen;
import org.apache.cassandra.spark.data.complex.CqlUdt;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.types.Ascii;
import org.apache.cassandra.spark.data.types.BigInt;
import org.apache.cassandra.spark.data.types.Blob;
import org.apache.cassandra.spark.data.types.Boolean;
import org.apache.cassandra.spark.data.types.Counter;
import org.apache.cassandra.spark.data.types.Date;
import org.apache.cassandra.spark.data.types.Decimal;
import org.apache.cassandra.spark.data.types.Double;
import org.apache.cassandra.spark.data.types.Duration;
import org.apache.cassandra.spark.data.types.Empty;
import org.apache.cassandra.spark.data.types.Float;
import org.apache.cassandra.spark.data.types.Inet;
import org.apache.cassandra.spark.data.types.Int;
import org.apache.cassandra.spark.data.types.SmallInt;
import org.apache.cassandra.spark.data.types.Text;
import org.apache.cassandra.spark.data.types.Time;
import org.apache.cassandra.spark.data.types.TimeUUID;
import org.apache.cassandra.spark.data.types.Timestamp;
import org.apache.cassandra.spark.data.types.TinyInt;
import org.apache.cassandra.spark.data.types.UUID;
import org.apache.cassandra.spark.data.types.VarChar;
import org.apache.cassandra.spark.data.types.VarInt;

public abstract class AbstractCassandraTypes
extends CassandraTypes {
    protected static volatile boolean setup = false;
    private final Map<String, CqlField.NativeType> nativeTypes = this.allTypes().stream().collect(Collectors.toMap(CqlField.CqlType::name, Function.identity()));

    public static IPartitioner getPartitioner(Partitioner partitioner) {
        return partitioner == Partitioner.Murmur3Partitioner ? Murmur3Partitioner.instance : RandomPartitioner.instance;
    }

    public String maybeQuoteIdentifier(String identifier) {
        if (AbstractCassandraTypes.isAlreadyQuoted((String)identifier)) {
            return identifier;
        }
        return ColumnIdentifier.maybeQuote((String)identifier);
    }

    public Map<String, ? extends CqlField.NativeType> nativeTypeNames() {
        return this.nativeTypes;
    }

    public CqlField.CqlType readType(CqlField.CqlType.InternalType type, Input input) {
        switch (type) {
            case NativeCql: {
                return this.nativeType(input.readString());
            }
            case Set: 
            case List: 
            case Map: 
            case Tuple: {
                return CqlCollection.read(type, input, this);
            }
            case Frozen: {
                return CqlFrozen.build(CqlField.CqlType.read((Input)input, (CassandraTypes)this));
            }
            case Udt: {
                return CqlUdt.read(input, this);
            }
        }
        throw new IllegalStateException("Unknown CQL type, cannot deserialize");
    }

    public Ascii ascii() {
        return Ascii.INSTANCE;
    }

    public Blob blob() {
        return Blob.INSTANCE;
    }

    public Boolean bool() {
        return Boolean.INSTANCE;
    }

    public Counter counter() {
        return Counter.INSTANCE;
    }

    public BigInt bigint() {
        return BigInt.INSTANCE;
    }

    public Date date() {
        return Date.INSTANCE;
    }

    public Decimal decimal() {
        return Decimal.INSTANCE;
    }

    public Double aDouble() {
        return Double.INSTANCE;
    }

    public Duration duration() {
        return Duration.INSTANCE;
    }

    public Empty empty() {
        return Empty.INSTANCE;
    }

    public Float aFloat() {
        return Float.INSTANCE;
    }

    public Inet inet() {
        return Inet.INSTANCE;
    }

    public Int aInt() {
        return Int.INSTANCE;
    }

    public SmallInt smallint() {
        return SmallInt.INSTANCE;
    }

    public Text text() {
        return Text.INSTANCE;
    }

    public Time time() {
        return Time.INSTANCE;
    }

    public Timestamp timestamp() {
        return Timestamp.INSTANCE;
    }

    public TimeUUID timeuuid() {
        return TimeUUID.INSTANCE;
    }

    public TinyInt tinyint() {
        return TinyInt.INSTANCE;
    }

    public UUID uuid() {
        return UUID.INSTANCE;
    }

    public VarChar varchar() {
        return VarChar.INSTANCE;
    }

    public VarInt varint() {
        return VarInt.INSTANCE;
    }

    public CqlField.CqlType collection(String name, CqlField.CqlType ... types) {
        return CqlCollection.build(name, types);
    }

    public CqlField.CqlList list(CqlField.CqlType type) {
        return CqlCollection.list(type);
    }

    public CqlField.CqlSet set(CqlField.CqlType type) {
        return CqlCollection.set(type);
    }

    public CqlField.CqlMap map(CqlField.CqlType keyType, CqlField.CqlType valueType) {
        return CqlCollection.map(keyType, valueType);
    }

    public CqlField.CqlTuple tuple(CqlField.CqlType ... types) {
        return CqlCollection.tuple(types);
    }

    public CqlField.CqlType frozen(CqlField.CqlType type) {
        return CqlFrozen.build(type);
    }

    public CqlField.CqlUdtBuilder udt(String keyspace, String name) {
        return CqlUdt.builder(keyspace, name);
    }
}

