/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.BulkWriteValidator;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class BulkWriteValidatorTest {
    BulkWriteValidatorTest() {
    }

    @Test
    void testConsistencyCheckFailureWhenDownInstancesFailQuorum() {
        BulkWriterContext mockWriterContext = (BulkWriterContext)Mockito.mock(BulkWriterContext.class);
        ClusterInfo mockClusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)mockWriterContext.cluster()).thenReturn((Object)mockClusterInfo);
        CassandraContext mockCassandraContext = (CassandraContext)Mockito.mock(CassandraContext.class);
        Mockito.when((Object)mockClusterInfo.getCassandraContext()).thenReturn((Object)mockCassandraContext);
        HashMap<String, String> replicationOptions = new HashMap<String, String>();
        replicationOptions.put("class", "SimpleStrategy");
        replicationOptions.put("replication_factor", "3");
        Mockito.when((Object)mockClusterInfo.replicationFactor()).thenReturn((Object)new ReplicationFactor(replicationOptions));
        TokenRangeMapping topology = TokenRangeMapping.create(() -> TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(10, 3), () -> Partitioner.Murmur3Partitioner, metadata -> new RingInstance(metadata, null));
        Mockito.when((Object)mockClusterInfo.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn((Object)topology);
        HashMap<RingInstance, WriteAvailability> instanceAvailabilityMap = new HashMap<RingInstance, WriteAvailability>(10);
        Iterator iterator = topology.getTokenRanges().keySet().iterator();
        while (iterator.hasNext()) {
            RingInstance instance;
            int nodeId = Integer.parseInt((instance = (RingInstance)iterator.next()).ipAddress().replace("localhost", ""));
            instanceAvailabilityMap.put(instance, nodeId <= 2 ? WriteAvailability.UNAVAILABLE_DOWN : WriteAvailability.AVAILABLE);
        }
        Mockito.when((Object)mockClusterInfo.clusterWriteAvailability()).thenReturn(instanceAvailabilityMap);
        JobInfo mockJobInfo = (JobInfo)Mockito.mock(JobInfo.class);
        UUID jobId = UUID.randomUUID();
        Mockito.when((Object)mockJobInfo.getId()).thenReturn((Object)jobId.toString());
        Mockito.when((Object)mockJobInfo.getRestoreJobId()).thenReturn((Object)jobId);
        Mockito.when((Object)mockJobInfo.qualifiedTableName()).thenReturn((Object)new QualifiedTableName("testkeyspace", "testtable"));
        Mockito.when((Object)mockJobInfo.getConsistencyLevel()).thenReturn((Object)ConsistencyLevel.CL.QUORUM);
        Mockito.when((Object)mockJobInfo.effectiveSidecarPort()).thenReturn((Object)9043);
        Mockito.when((Object)mockJobInfo.jobKeepAliveMinutes()).thenReturn((Object)-1);
        Mockito.when((Object)mockWriterContext.job()).thenReturn((Object)mockJobInfo);
        MultiClusterReplicaAwareFailureHandler failureHandler = new MultiClusterReplicaAwareFailureHandler(Partitioner.Murmur3Partitioner);
        BulkWriteValidator writerValidator = new BulkWriteValidator(mockWriterContext, (ReplicaAwareFailureHandler)failureHandler);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writerValidator.validateClOrFail(topology)).isExactlyInstanceOf(ConsistencyNotSatisfiedException.class)).hasMessageContaining("Failed to write");
    }
}

