/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.spark.data.CassandraDataLayer;
import org.apache.cassandra.spark.data.CassandraDataSourceHelper;
import org.apache.cassandra.spark.data.ClientConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CassandraDataSourceHelperCacheTest {
    public static final Map<String, String> REQUIRED_CLIENT_CONFIG_OPTIONS = ImmutableMap.of((Object)"sidecar_contact_points", (Object)"127.0.0.1", (Object)"keyspace", (Object)"big-data", (Object)"table", (Object)"customers");
    private CacheTicker cacheTicker;

    @BeforeEach
    public void setup() {
        this.cacheTicker = new CacheTicker();
        CassandraDataSourceHelper.initCassandraDataSourceCache((Ticker)this.cacheTicker);
    }

    @Test
    public void testCassandraDataLayerCacheExpiration() throws ExecutionException {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        Cache cassandraDataLayerCache = CassandraDataSourceHelper.getCassandraDataLayerCache();
        CassandraDataLayer dataLayer = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
        Assertions.assertThat((Object)dataLayer).isNotNull();
        this.cacheTicker.advance(1L, TimeUnit.MINUTES);
        CassandraDataLayer dataLayer1 = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
        Assertions.assertThat((Object)dataLayer1).isSameAs((Object)dataLayer);
        this.cacheTicker.advance(1L, TimeUnit.HOURS);
        CassandraDataLayer dataLayer2 = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
        Assertions.assertThat((Object)dataLayer2).isSameAs((Object)dataLayer);
        this.cacheTicker.advance(10L, TimeUnit.HOURS);
        this.cacheTicker.advance(58L, TimeUnit.MINUTES);
        this.cacheTicker.advance(59L, TimeUnit.SECONDS);
        CassandraDataLayer dataLayer3 = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
        Assertions.assertThat((Object)dataLayer3).isSameAs((Object)dataLayer);
        this.cacheTicker.advance(1L, TimeUnit.SECONDS);
        CassandraDataLayer dataLayer4 = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
        Assertions.assertThat((Object)dataLayer4).isNotSameAs((Object)dataLayer);
    }

    @Test
    public void testMultipleThreadsAccessingTheSameKey() throws InterruptedException, ExecutionException {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        Cache cassandraDataLayerCache = CassandraDataSourceHelper.getCassandraDataLayerCache();
        int threads = 20;
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        CassandraDataLayer[] cassandraDataLayerArray = new CassandraDataLayer[threads];
        CountDownLatch latch = new CountDownLatch(threads);
        int thread = 0;
        while (thread < threads) {
            int finalI = thread++;
            pool.submit(() -> {
                try {
                    latch.countDown();
                    latch.await();
                    cassandraDataLayerArray[finalI] = this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options);
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        pool.shutdown();
        Assertions.assertThat((boolean)pool.awaitTermination(1L, TimeUnit.MINUTES)).isTrue();
        for (thread = 1; thread < threads; ++thread) {
            Assertions.assertThat((Object)cassandraDataLayerArray[thread]).isSameAs((Object)cassandraDataLayerArray[0]);
        }
        this.cacheTicker.advance(12L, TimeUnit.HOURS);
        Assertions.assertThat((Object)this.getCassandraDataLayer((Cache<Map<String, String>, CassandraDataLayer>)cassandraDataLayerCache, options, options)).isNotSameAs((Object)cassandraDataLayerArray[0]);
    }

    private CassandraDataLayer getCassandraDataLayer(Cache<Map<String, String>, CassandraDataLayer> cassandraDataLayerCache, Map<String, String> key, Map<String, String> options) throws ExecutionException {
        return (CassandraDataLayer)cassandraDataLayerCache.get(key, () -> {
            ClientConfig config = ClientConfig.create((Map)options);
            return new CassandraDataLayer(config, Sidecar.ClientConfig.create((Map)options), SslConfig.create((Map)options));
        });
    }

    private static class CacheTicker
    extends Ticker {
        private final AtomicLong nanos = new AtomicLong(0L);

        private CacheTicker() {
        }

        public long read() {
            return this.nanos.get();
        }

        public void advance(long value, TimeUnit unit) {
            this.nanos.addAndGet(unit.toNanos(value));
        }
    }
}

