/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.utils.BufferingInputStreamTests;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.streaming.StreamBuffer;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingInputStreamHttpTest {
    static final ExecutorService HTTP_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("http-server-%d").setDaemon(true).build());
    static final ExecutorService HTTP_CLIENT = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("http-client-%d").setDaemon(true).build());
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferingInputStreamHttpTest.class);
    @TempDir
    private static Path directory;
    private static final String HOST = "localhost";
    private static final int PORT = 8001;
    private static final int HTTP_CLIENT_CHUNK_SIZE = 8192;
    private static HttpServer SERVER;
    private static CloseableHttpClient CLIENT;

    @BeforeAll
    public static void setup() throws IOException {
        SERVER = HttpServer.create(new InetSocketAddress(HOST, 8001), 0);
        SERVER.setExecutor(HTTP_EXECUTOR);
        SERVER.createContext("/", exchange -> {
            try {
                long end;
                long start;
                String uri = exchange.getRequestURI().getPath().replaceFirst("/", "");
                Path path = directory.resolve(uri);
                long size = Files.size(path);
                String rangeHeader = exchange.getRequestHeaders().getFirst("Range");
                if (rangeHeader != null) {
                    String[] range = rangeHeader.split("=")[1].split("-");
                    start = Long.parseLong(range[0]);
                    long endValue = Long.parseLong(range[1]);
                    if (endValue < start) {
                        exchange.sendResponseHeaders(416, -1L);
                        return;
                    }
                    end = Math.min(size - 1L, endValue);
                } else {
                    start = 0L;
                    end = size;
                }
                int length = (int)(end - start + 1L);
                if (length <= 0) {
                    exchange.sendResponseHeaders(200, -1L);
                    return;
                }
                LOGGER.info("Serving file filename={} start={} end={} length={}", new Object[]{path.getFileName(), start, end, length});
                exchange.sendResponseHeaders(200, length);
                try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
                    byte[] bytes = new byte[length];
                    raf.seek(start);
                    raf.read(bytes, 0, length);
                    exchange.getResponseBody().write(bytes);
                }
                exchange.getResponseBody().flush();
            }
            catch (Throwable throwable) {
                LOGGER.error("Unexpected exception in in-test HTTP server", throwable);
                exchange.sendResponseHeaders(500, -1L);
            }
            finally {
                exchange.close();
            }
        });
        SERVER.start();
        LOGGER.info("Started in-test HTTP Server host={} port={}", (Object)HOST, (Object)8001);
        CLIENT = HttpClients.createDefault();
    }

    @AfterAll
    public static void tearDown() {
        SERVER.stop(0);
    }

    private static CassandraFileSource<SSTable> buildHttpSource(final String filename, final long size, final Long maxBufferSize, final Long chunkBufferSize) {
        return new CassandraFileSource<SSTable>(){

            public void request(long start, long end, StreamConsumer consumer) {
                CompletableFuture.runAsync(() -> {
                    block11: {
                        LOGGER.info("Reading file using HTTP client filename={} start={} end={}", new Object[]{filename, start, end});
                        HttpGet get = new HttpGet("http://localhost:8001/" + filename);
                        get.setHeader("Range", String.format("bytes=%d-%d", start, end));
                        try {
                            CloseableHttpResponse resp = CLIENT.execute((HttpUriRequest)get);
                            if (resp.getStatusLine().getStatusCode() == 200) {
                                try (InputStream is = resp.getEntity().getContent();){
                                    int length;
                                    byte[] bytes = new byte[8192];
                                    while ((length = is.read(bytes, 0, bytes.length)) >= 0) {
                                        if (length < 8192) {
                                            byte[] copy = new byte[length];
                                            System.arraycopy(bytes, 0, copy, 0, length);
                                            bytes = copy;
                                        }
                                        consumer.onRead((StreamBuffer)StreamBuffer.wrap((byte[])bytes));
                                        bytes = new byte[8192];
                                    }
                                    consumer.onEnd();
                                    break block11;
                                }
                            }
                            consumer.onError((Throwable)new RuntimeException("Unexpected status code: " + resp.getStatusLine().getStatusCode()));
                        }
                        catch (IOException exception) {
                            consumer.onError((Throwable)exception);
                        }
                    }
                }, HTTP_CLIENT);
            }

            public long maxBufferSize() {
                return maxBufferSize != null ? maxBufferSize.longValue() : super.maxBufferSize();
            }

            public long chunkBufferSize() {
                return chunkBufferSize != null ? chunkBufferSize.longValue() : super.chunkBufferSize();
            }

            public SSTable cassandraFile() {
                return null;
            }

            public FileType fileType() {
                return null;
            }

            public long size() {
                return size;
            }
        };
    }

    @Test
    public void testSmallChunkSizes() {
        List<Long> fileSizes = Arrays.asList(1L, 1536L, 32768L, 250000L, 10485800L);
        QuickTheory.qt().forAll(SourceDSL.arbitrary().pick(fileSizes)).checkAssert(size -> this.runHttpTest((long)size, 8192L, 4096L));
    }

    @Test
    public void testDefaultClientConfig() {
        List<Long> fileSizes = Arrays.asList(1L, 13L, 512L, 1024L, 1536L, 32768L, 1000000L, 10485800L, 1000000000L);
        QuickTheory.qt().forAll(SourceDSL.arbitrary().pick(fileSizes)).checkAssert(this::runHttpTest);
    }

    private void runHttpTest(long size) {
        this.runHttpTest(size, null, null);
    }

    private void runHttpTest(long size, Long maxBufferSize, Long chunkBufferSize) {
        try {
            long blockingTimeMillis;
            byte[] actualMD5;
            Path path = Files.createTempFile(directory, null, null, new FileAttribute[0]);
            MessageDigest digest = DigestUtils.getMd5Digest();
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                byte[] bytes;
                for (long remaining = size; remaining > 0L; remaining -= (long)bytes.length) {
                    bytes = RandomUtils.randomBytes((int)((int)Math.min(remaining, 8192L)));
                    out.write(bytes);
                    digest.update(bytes);
                }
            }
            byte[] expectedMD5 = digest.digest();
            Assertions.assertThat((Path)path).hasSize(size);
            LOGGER.info("Created random file path={} fileSize={}", (Object)path, (Object)size);
            CassandraFileSource<SSTable> source = BufferingInputStreamHttpTest.buildHttpSource(path.getFileName().toString(), Files.size(path), maxBufferSize, chunkBufferSize);
            try (BufferingInputStream is = new BufferingInputStream(source, BufferingInputStreamTests.STATS.bufferingInputStreamStats());){
                actualMD5 = DigestUtils.md5((InputStream)is);
                blockingTimeMillis = TimeUnit.MILLISECONDS.convert(is.timeBlockedNanos(), TimeUnit.NANOSECONDS);
                Assertions.assertThat((long)is.bytesRead()).isEqualTo(size);
                Assertions.assertThat((long)is.bytesBuffered()).isEqualTo(0L);
            }
            LOGGER.info("Time spent blocking on InputStream thread blockingTimeMillis={} fileSize={}", (Object)blockingTimeMillis, (Object)size);
            Assertions.assertThat((byte[])actualMD5).isEqualTo((Object)expectedMD5);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

