/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.masking;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.masking.MaskingFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public class NullMaskingFunction
extends MaskingFunction {
    public static final String NAME = "null";

    private NullMaskingFunction(FunctionName name, AbstractType<?> inputType) {
        super(name, inputType, inputType, new AbstractType[0]);
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return FunctionArguments.newNoopInstance(version, 1);
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        return null;
    }

    public static FunctionFactory factory() {
        return new MaskingFunction.Factory(NAME, new FunctionParameter[]{FunctionParameter.anyType(false)}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                return new NullMaskingFunction(this.name, argTypes.get(0));
            }
        };
    }
}

