/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.MutationExceededMaxSizeException;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.TeeDataInputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class Mutation
implements IMutation,
Supplier<Mutation> {
    public static final MutationSerializer serializer = new MutationSerializer();
    private final String keyspaceName;
    private final DecoratedKey key;
    private final ImmutableMap<TableId, PartitionUpdate> modifications;
    final long approxCreatedAtNanos;
    final AtomicLong viewLockAcquireStart = new AtomicLong(0L);
    private final boolean cdcEnabled;
    private static final int SERIALIZATION_VERSION_COUNT = MessagingService.Version.values().length;
    private final Serialization[] cachedSerializations = new Serialization[SERIALIZATION_VERSION_COUNT];
    private static final long CACHEABLE_MUTATION_SIZE_LIMIT = CassandraRelevantProperties.CACHEABLE_MUTATION_SIZE_LIMIT.getLong();
    private int serializedSize40;
    private int serializedSize50;

    public Mutation(PartitionUpdate update) {
        this(update.metadata().keyspace, update.partitionKey(), ImmutableMap.of(update.metadata().id, update), MonotonicClock.Global.approxTime.now(), update.metadata().params.cdc);
    }

    public Mutation(String keyspaceName, DecoratedKey key, ImmutableMap<TableId, PartitionUpdate> modifications, long approxCreatedAtNanos) {
        this(keyspaceName, key, modifications, approxCreatedAtNanos, Mutation.cdcEnabled(modifications.values()));
    }

    public Mutation(String keyspaceName, DecoratedKey key, ImmutableMap<TableId, PartitionUpdate> modifications, long approxCreatedAtNanos, boolean cdcEnabled) {
        this.keyspaceName = keyspaceName;
        this.key = key;
        this.modifications = modifications;
        this.cdcEnabled = cdcEnabled;
        this.approxCreatedAtNanos = approxCreatedAtNanos;
    }

    private static boolean cdcEnabled(Iterable<PartitionUpdate> modifications) {
        boolean cdc = false;
        for (PartitionUpdate pu : modifications) {
            cdc |= pu.metadata().params.cdc;
        }
        return cdc;
    }

    public Mutation without(Set<TableId> tableIds) {
        if (tableIds.isEmpty()) {
            return this;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry update : this.modifications.entrySet()) {
            if (tableIds.contains(update.getKey())) continue;
            builder.put(update);
        }
        return new Mutation(this.keyspaceName, this.key, builder.build(), this.approxCreatedAtNanos);
    }

    public Mutation without(TableId tableId) {
        return this.without(Collections.singleton(tableId));
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public Collection<TableId> getTableIds() {
        return this.modifications.keySet();
    }

    @Override
    public DecoratedKey key() {
        return this.key;
    }

    public ImmutableCollection<PartitionUpdate> getPartitionUpdates() {
        return this.modifications.values();
    }

    public long getApproxCreatedAtNanos() {
        return this.approxCreatedAtNanos;
    }

    @Override
    public Supplier<Mutation> hintOnFailure() {
        return this;
    }

    @Override
    public Mutation get() {
        return this;
    }

    @Override
    public void validateSize(int version, int overhead) {
        long totalSize = this.serializedSize(version) + overhead;
        if (totalSize > MAX_MUTATION_SIZE) {
            CommitLog.instance.metrics.oversizedMutations.mark();
            throw new MutationExceededMaxSizeException(this, version, totalSize);
        }
    }

    public PartitionUpdate getPartitionUpdate(TableMetadata table) {
        return table == null ? null : this.modifications.get(table.id);
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public static Mutation merge(List<Mutation> mutations) {
        assert (!mutations.isEmpty());
        if (mutations.size() == 1) {
            return mutations.get(0);
        }
        HashSet updatedTables = new HashSet();
        String ks = null;
        DecoratedKey key = null;
        for (Mutation mutation : mutations) {
            updatedTables.addAll(mutation.modifications.keySet());
            if (ks != null && !ks.equals(mutation.keyspaceName)) {
                throw new IllegalArgumentException();
            }
            if (key != null && !key.equals(mutation.key)) {
                throw new IllegalArgumentException();
            }
            ks = mutation.keyspaceName;
            key = mutation.key;
        }
        ArrayList<PartitionUpdate> updates = new ArrayList<PartitionUpdate>(mutations.size());
        ImmutableMap.Builder<TableId, PartitionUpdate> modifications = new ImmutableMap.Builder<TableId, PartitionUpdate>();
        for (TableId table : updatedTables) {
            for (Mutation mutation : mutations) {
                PartitionUpdate upd = mutation.modifications.get(table);
                if (upd == null) continue;
                updates.add(upd);
            }
            if (updates.isEmpty()) continue;
            modifications.put(table, updates.size() == 1 ? (PartitionUpdate)updates.get(0) : PartitionUpdate.merge(updates));
            updates.clear();
        }
        return new Mutation(ks, key, modifications.build(), MonotonicClock.Global.approxTime.now());
    }

    public Future<?> applyFuture() {
        Keyspace ks = Keyspace.open(this.keyspaceName);
        return ks.applyFuture(this, Keyspace.open((String)this.keyspaceName).getMetadata().params.durableWrites, true);
    }

    private void apply(Keyspace keyspace, boolean durableWrites, boolean isDroppable) {
        keyspace.apply(this, durableWrites, true, isDroppable);
    }

    public void apply(boolean durableWrites, boolean isDroppable) {
        this.apply(Keyspace.open(this.keyspaceName), durableWrites, isDroppable);
    }

    public void apply(boolean durableWrites) {
        this.apply(durableWrites, true);
    }

    @Override
    public void apply() {
        Keyspace keyspace = Keyspace.open(this.keyspaceName);
        this.apply(keyspace, keyspace.getMetadata().params.durableWrites, true);
    }

    public void applyUnsafe() {
        this.apply(false);
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getWriteRpcTimeout(unit);
    }

    public int smallestGCGS() {
        int gcgs = Integer.MAX_VALUE;
        for (PartitionUpdate update : this.getPartitionUpdates()) {
            gcgs = Math.min(gcgs, update.metadata().params.gcGraceSeconds);
        }
        return gcgs;
    }

    public boolean trackedByCDC() {
        return this.cdcEnabled;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("Mutation(");
        buff.append("keyspace='").append(this.keyspaceName).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key.getKey())).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>(this.modifications.size());
            for (TableId tableId : this.modifications.keySet()) {
                TableMetadata cfm = Schema.instance.getTableMetadata(tableId);
                cfnames.add(cfm == null ? "-dropped-" : cfm.name);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append("\n  ").append(StringUtils.join((Iterable)this.modifications.values(), (String)"\n  ")).append('\n');
        }
        return buff.append("])").toString();
    }

    public int serializedSize(int version) {
        switch (version) {
            case 12: {
                if (this.serializedSize40 == 0) {
                    this.serializedSize40 = (int)serializer.serializedSize(this, 12);
                }
                return this.serializedSize40;
            }
            case 13: {
                if (this.serializedSize50 == 0) {
                    this.serializedSize50 = (int)serializer.serializedSize(this, 13);
                }
                return this.serializedSize50;
            }
        }
        throw new IllegalStateException("Unknown serialization version: " + version);
    }

    public static SimpleBuilder simpleBuilder(String keyspaceName, DecoratedKey partitionKey) {
        return new SimpleBuilders.MutationBuilder(keyspaceName, partitionKey);
    }

    public static class PartitionUpdateCollector {
        private final ImmutableMap.Builder<TableId, PartitionUpdate> modifications = new ImmutableMap.Builder();
        private final String keyspaceName;
        private final DecoratedKey key;
        private final long approxCreatedAtNanos = MonotonicClock.Global.approxTime.now();
        private boolean empty = true;

        public PartitionUpdateCollector(String keyspaceName, DecoratedKey key) {
            this.keyspaceName = keyspaceName;
            this.key = key;
        }

        public PartitionUpdateCollector add(PartitionUpdate partitionUpdate) {
            assert (partitionUpdate != null);
            assert (partitionUpdate.partitionKey().getPartitioner() == this.key.getPartitioner());
            this.modifications.put(partitionUpdate.metadata().id, partitionUpdate);
            this.empty = false;
            return this;
        }

        public DecoratedKey key() {
            return this.key;
        }

        public String getKeyspaceName() {
            return this.keyspaceName;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Mutation build() {
            return new Mutation(this.keyspaceName, this.key, this.modifications.build(), this.approxCreatedAtNanos);
        }
    }

    private static final class SizeOnlyCacheableSerialization
    extends Serialization {
        private volatile long size;

        private SizeOnlyCacheableSerialization() {
        }

        @Override
        void serialize(PartitionUpdate.PartitionUpdateSerializer serializer, Mutation mutation, DataOutputPlus out, int version) throws IOException {
            MutationSerializer.serializeInternal(serializer, mutation, out, version);
        }

        @Override
        long serializedSize(PartitionUpdate.PartitionUpdateSerializer serializer, Mutation mutation, int version) {
            long size = this.size;
            if (size == 0L) {
                size = TypeSizes.sizeofUnsignedVInt(mutation.modifications.size());
                for (PartitionUpdate partitionUpdate : mutation.modifications.values()) {
                    size += serializer.serializedSize(partitionUpdate, version);
                }
                this.size = size;
            }
            return size;
        }
    }

    private static final class CachedSerialization
    extends Serialization {
        private final byte[] serialized;

        CachedSerialization(byte[] serialized) {
            this.serialized = Preconditions.checkNotNull(serialized);
        }

        @Override
        void serialize(PartitionUpdate.PartitionUpdateSerializer serializer, Mutation mutation, DataOutputPlus out, int version) throws IOException {
            out.write(this.serialized);
        }

        @Override
        long serializedSize(PartitionUpdate.PartitionUpdateSerializer serializer, Mutation mutation, int version) {
            return this.serialized.length;
        }
    }

    private static abstract class Serialization {
        private Serialization() {
        }

        abstract void serialize(PartitionUpdate.PartitionUpdateSerializer var1, Mutation var2, DataOutputPlus var3, int var4) throws IOException;

        abstract long serializedSize(PartitionUpdate.PartitionUpdateSerializer var1, Mutation var2, int var3);
    }

    public static class MutationSerializer
    implements IVersionedSerializer<Mutation> {
        @Override
        public void serialize(Mutation mutation, DataOutputPlus out, int version) throws IOException {
            this.serialization(mutation, version).serialize(PartitionUpdate.serializer, mutation, out, version);
        }

        public void prepareSerializedBuffer(Mutation mutation, int version) {
            this.serialization(mutation, version);
        }

        private Serialization serialization(Mutation mutation, int version) {
            int versionOrdinal = MessagingService.getVersionOrdinal(version);
            Serialization serialization = mutation.cachedSerializations[versionOrdinal];
            if (serialization == null) {
                serialization = new SizeOnlyCacheableSerialization();
                long serializedSize = serialization.serializedSize(PartitionUpdate.serializer, mutation, version);
                if (serializedSize < CACHEABLE_MUTATION_SIZE_LIMIT) {
                    try (DataOutputBuffer dob = DataOutputBuffer.scratchBuffer.get();){
                        MutationSerializer.serializeInternal(PartitionUpdate.serializer, mutation, dob, version);
                        serialization = new CachedSerialization(dob.toByteArray());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                mutation.cachedSerializations[versionOrdinal] = serialization;
            }
            return serialization;
        }

        static void serializeInternal(PartitionUpdate.PartitionUpdateSerializer serializer, Mutation mutation, DataOutputPlus out, int version) throws IOException {
            ImmutableMap<TableId, PartitionUpdate> modifications = mutation.modifications;
            int size = modifications.size();
            out.writeUnsignedVInt32(size);
            assert (size > 0);
            for (PartitionUpdate partitionUpdate : modifications.values()) {
                serializer.serialize(partitionUpdate, out, version);
            }
        }

        public Mutation deserialize(DataInputPlus in, int version, DeserializationHelper.Flag flag) throws IOException {
            try (DataOutputBuffer dob = DataOutputBuffer.scratchBuffer.get();){
                Mutation m4;
                TeeDataInputPlus teeIn = new TeeDataInputPlus(in, dob, CACHEABLE_MUTATION_SIZE_LIMIT);
                int size = teeIn.readUnsignedVInt32();
                assert (size > 0);
                PartitionUpdate update = PartitionUpdate.serializer.deserialize(teeIn, version, flag);
                if (size == 1) {
                    m4 = new Mutation(update);
                } else {
                    ImmutableMap.Builder<TableId, PartitionUpdate> modifications = new ImmutableMap.Builder<TableId, PartitionUpdate>();
                    DecoratedKey dk = update.partitionKey();
                    modifications.put(update.metadata().id, update);
                    for (int i = 1; i < size; ++i) {
                        update = PartitionUpdate.serializer.deserialize(teeIn, version, flag);
                        modifications.put(update.metadata().id, update);
                    }
                    m4 = new Mutation(update.metadata().keyspace, dk, modifications.build(), MonotonicClock.Global.approxTime.now());
                }
                if (!teeIn.isLimitReached()) {
                    m4.cachedSerializations[MessagingService.getVersionOrdinal((int)version)] = new CachedSerialization(dob.toByteArray());
                }
                Mutation mutation = m4;
                return mutation;
            }
        }

        @Override
        public Mutation deserialize(DataInputPlus in, int version) throws IOException {
            return this.deserialize(in, version, DeserializationHelper.Flag.FROM_REMOTE);
        }

        @Override
        public long serializedSize(Mutation mutation, int version) {
            return this.serialization(mutation, version).serializedSize(PartitionUpdate.serializer, mutation, version);
        }
    }

    public static interface SimpleBuilder {
        public SimpleBuilder timestamp(long var1);

        public SimpleBuilder ttl(int var1);

        public PartitionUpdate.SimpleBuilder update(TableMetadata var1);

        public PartitionUpdate.SimpleBuilder update(String var1);

        public Mutation build();
    }
}

