/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;

public class PartitionRangeReadCommand
extends ReadCommand
implements PartitionRangeReadQuery {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    protected final Slices requestedSlices;

    @VisibleForTesting
    protected PartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, Index.QueryPlan indexQueryPlan, boolean trackWarnings) {
        super(ReadCommand.Kind.PARTITION_RANGE, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, indexQueryPlan, trackWarnings, dataRange);
        this.requestedSlices = dataRange.clusteringIndexFilter.getSlices(this.metadata());
    }

    private static PartitionRangeReadCommand create(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, Index.QueryPlan indexQueryPlan, boolean trackWarnings) {
        if (metadata.isVirtual()) {
            return new VirtualTablePartitionRangeReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, indexQueryPlan, trackWarnings);
        }
        return new PartitionRangeReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, indexQueryPlan, trackWarnings);
    }

    public static PartitionRangeReadCommand create(TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        return PartitionRangeReadCommand.create(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, PartitionRangeReadCommand.findIndexQueryPlan(metadata, rowFilter), false);
    }

    public static PartitionRangeReadCommand allDataRead(TableMetadata metadata, long nowInSec) {
        return PartitionRangeReadCommand.create(false, 0, false, metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.none(), DataLimits.NONE, DataRange.allData(metadata.partitioner), null, false);
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.dataRange.clusteringIndexFilter(key);
    }

    public boolean isNamesQuery() {
        return this.dataRange.isNamesQuery();
    }

    public PartitionRangeReadCommand forSubRange(AbstractBounds<PartitionPosition> range, boolean isRangeContinuation) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), isRangeContinuation ? this.limits() : this.limits().withoutState(), this.dataRange().forSubRange(range), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand copy() {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    protected PartitionRangeReadCommand copyAsDigestQuery() {
        return PartitionRangeReadCommand.create(true, this.digestVersion(), false, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    protected PartitionRangeReadCommand copyAsTransientQuery() {
        return PartitionRangeReadCommand.create(false, 0, true, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimit(DataLimits newLimits) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.dataRange(), this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimitsAndDataRange(DataLimits newLimits, DataRange newDataRange) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, newDataRange, this.indexQueryPlan(), this.isTrackingWarnings());
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getRangeRpcTimeout(unit);
    }

    @Override
    public boolean isReversed() {
        return this.dataRange.isReversed();
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
        return StorageProxy.getRangeSlice(this, consistency, requestTime);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.rangeLatency.addNano(latencyNanos);
    }

    @Override
    @VisibleForTesting
    public UnfilteredPartitionIterator queryStorage(final ColumnFamilyStore cfs, ReadExecutionController controller) {
        ColumnFamilyStore.ViewFragment view = cfs.select(View.selectLive(this.dataRange().keyRange()));
        Tracing.trace("Executing seq scan across {} sstables for {}", (Object)view.sstables.size(), (Object)this.dataRange().keyRange().getString(this.metadata().partitionKeyType));
        ReadCommand.InputCollector<UnfilteredPartitionIterator> inputCollector = this.iteratorsForRange(view, controller);
        try {
            SSTableReadsListener readCountUpdater = PartitionRangeReadCommand.newReadCountUpdater();
            for (Memtable memtable : view.memtables) {
                UnfilteredPartitionIterator iter2 = memtable.partitionIterator(this.columnFilter(), this.dataRange(), readCountUpdater);
                controller.updateMinOldestUnrepairedTombstone(memtable.getMinLocalDeletionTime());
                inputCollector.addMemtableIterator(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.MEMTABLE, false));
            }
            int selectedSSTablesCnt = 0;
            for (SSTableReader sstable : view.sstables) {
                boolean intersects = this.intersects(sstable);
                boolean hasPartitionLevelDeletions = this.hasPartitionLevelDeletions(sstable);
                boolean hasRequiredStatics = this.hasRequiredStatics(sstable);
                if (!intersects && !hasPartitionLevelDeletions && !hasRequiredStatics) continue;
                UnfilteredPartitionIterator iter3 = sstable.partitionIterator(this.columnFilter(), this.dataRange(), readCountUpdater);
                inputCollector.addSSTableIterator(sstable, RTBoundValidator.validate(iter3, RTBoundValidator.Stage.SSTABLE, false));
                if (!sstable.isRepaired()) {
                    controller.updateMinOldestUnrepairedTombstone(sstable.getMinLocalDeletionTime());
                }
                ++selectedSSTablesCnt;
            }
            final int n = selectedSSTablesCnt;
            if (inputCollector.isEmpty()) {
                return EmptyIterators.unfilteredPartition(this.metadata());
            }
            List<UnfilteredPartitionIterator> finalizedIterators = inputCollector.finalizeIterators(cfs, this.nowInSec(), controller.oldestUnrepairedTombstone());
            UnfilteredPartitionIterator merged = UnfilteredPartitionIterators.mergeLazily(finalizedIterators);
            return this.checkCacheFilter(Transformation.apply(merged, (Transformation<? super UnfilteredRowIterator>)new Transformation<UnfilteredRowIterator>(){

                @Override
                protected void onClose() {
                    super.onClose();
                    cfs.metric.updateSSTableIteratedInRangeRead(n);
                }
            }), cfs);
        }
        catch (Error | RuntimeException e) {
            try {
                inputCollector.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    @Override
    protected boolean intersects(SSTableReader sstable) {
        return this.requestedSlices.intersects(sstable.getSSTableMetadata().coveredClustering);
    }

    private static SSTableReadsListener newReadCountUpdater() {
        return new SSTableReadsListener(){

            @Override
            public void onScanningStarted(SSTableReader sstable) {
                sstable.incrementReadCount();
            }
        };
    }

    private UnfilteredPartitionIterator checkCacheFilter(UnfilteredPartitionIterator iter2, final ColumnFamilyStore cfs) {
        class CacheFilter
        extends Transformation<BaseRowIterator<?>> {
            CacheFilter() {
            }

            @Override
            public BaseRowIterator<?> applyToPartition(BaseRowIterator<?> iter2) {
                DecoratedKey dk = iter2.partitionKey();
                CachedPartition cached = cfs.getRawCachedPartition(dk);
                ClusteringIndexFilter filter = PartitionRangeReadCommand.this.dataRange().clusteringIndexFilter(dk);
                if (cached != null && cfs.isFilterFullyCoveredBy(filter, PartitionRangeReadCommand.this.limits(), cached, PartitionRangeReadCommand.this.nowInSec(), iter2.metadata().enforceStrictLiveness())) {
                    iter2.close();
                    return filter.getUnfilteredRowIterator(PartitionRangeReadCommand.this.columnFilter(), cached);
                }
                return iter2;
            }
        }
        return Transformation.apply(iter2, new CacheFilter());
    }

    @Override
    public Verb verb() {
        return Verb.RANGE_REQ;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString = this.dataRange().toCQLString(this.metadata(), this.rowFilter());
        if (!filterString.isEmpty()) {
            sb.append(" WHERE ").append(filterString);
        }
    }

    @Override
    public String loggableTokens() {
        return "token range: " + (this.dataRange.keyRange.inclusiveLeft() ? (char)'[' : '(') + ((PartitionPosition)this.dataRange.keyRange.left).getToken().toString() + ", " + ((PartitionPosition)this.dataRange.keyRange.right).getToken().toString() + (this.dataRange.keyRange.inclusiveRight() ? (char)']' : ')');
    }

    public PartitionIterator postReconciliationProcessing(PartitionIterator result) {
        Index.QueryPlan queryPlan = this.indexQueryPlan();
        return queryPlan == null ? result : queryPlan.postProcessor(this).apply(result);
    }

    public String toString() {
        return String.format("Read(%s columns=%s rowfilter=%s limits=%s %s)", this.metadata().toString(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange().toString(this.metadata()));
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        DataRange.serializer.serialize(this.dataRange(), out, version, this.metadata());
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return DataRange.serializer.serializedSize(this.dataRange(), version, this.metadata());
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return this.dataRange.keyRange instanceof Bounds && this.dataRange.startKey().kind() == PartitionPosition.Kind.ROW_KEY && this.dataRange.startKey().equals(this.dataRange.stopKey());
    }

    @Override
    public boolean isRangeRequest() {
        return true;
    }

    public static class VirtualTablePartitionRangeReadCommand
    extends PartitionRangeReadCommand {
        private VirtualTablePartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, Index.QueryPlan indexQueryPlan, boolean trackWarnings) {
            super(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, indexQueryPlan, trackWarnings);
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
            return this.executeInternal(this.executionController());
        }

        @Override
        public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
            VirtualTable view = VirtualKeyspaceRegistry.instance.getTableNullable(this.metadata().id);
            UnfilteredPartitionIterator resultIterator = view.select(this.dataRange, this.columnFilter());
            return this.limits().filter(this.rowFilter().filter(resultIterator, this.nowInSec()), this.nowInSec(), this.selectsFullPartition());
        }

        @Override
        public ReadExecutionController executionController() {
            return ReadExecutionController.empty();
        }

        @Override
        public ReadExecutionController executionController(boolean trackRepairedStatus) {
            return this.executionController();
        }
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, long nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, Index.QueryPlan indexQueryPlan) throws IOException {
            DataRange range = DataRange.serializer.deserialize(in, version, metadata);
            return PartitionRangeReadCommand.create(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, range, indexQueryPlan, false);
        }
    }
}

