/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TruncateRequest;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateVerbHandler
implements IVerbHandler<TruncateRequest> {
    public static final TruncateVerbHandler instance = new TruncateVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(TruncateVerbHandler.class);

    @Override
    public void doVerb(Message<TruncateRequest> message) {
        TruncateRequest truncation = (TruncateRequest)message.payload;
        Tracing.trace("Applying truncation of {}.{}", (Object)truncation.keyspace, (Object)truncation.table);
        ColumnFamilyStore cfs = Keyspace.open(truncation.keyspace).getColumnFamilyStore(truncation.table);
        cfs.truncateBlocking();
        Tracing.trace("Enqueuing response to truncate operation to {}", (Object)message.from());
        TruncateResponse response = new TruncateResponse(truncation.keyspace, truncation.table, true);
        logger.trace("{} applied.  Enqueuing response to {}@{} ", new Object[]{truncation, message.id(), message.from()});
        MessagingService.instance().send(message.responseWith((TruncateRequest)((Object)response)), message.from());
    }
}

