/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CQLMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("CQL");
    public final Counter regularStatementsExecuted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("RegularStatementsExecuted"));
    public final Counter preparedStatementsExecuted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("PreparedStatementsExecuted"));
    public final Counter preparedStatementsEvicted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("PreparedStatementsEvicted"));
    public final Counter useStatementsExecuted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("UseStatementsExecuted"));
    public final Gauge<Integer> preparedStatementsCount = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PreparedStatementsCount"), QueryProcessor::preparedStatementsCount);
    public final Gauge<Double> preparedStatementsRatio = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PreparedStatementsRatio"), new RatioGauge(){

        @Override
        public RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of(this.getNumerator(), this.getDenominator());
        }

        public double getNumerator() {
            return CQLMetrics.this.preparedStatementsExecuted.getCount();
        }

        public double getDenominator() {
            return CQLMetrics.this.regularStatementsExecuted.getCount() + CQLMetrics.this.preparedStatementsExecuted.getCount();
        }
    });
}

