/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="clearsnapshot", description="Remove the snapshot with the given name from the given keyspaces")
public class ClearSnapshot
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspaces>...] ", description="Remove snapshots from the given keyspaces")
    private List<String> keyspaces = new ArrayList<String>();
    @Option(title="snapshot_name", name={"-t"}, description="Remove the snapshot with a given name")
    private String snapshotName = "";
    @Option(title="clear_all_snapshots", name={"--all"}, description="Removes all snapshots")
    private boolean clearAllSnapshots = false;
    @Option(title="older_than", name={"--older-than"}, description="Clear snapshots older than specified time period.")
    private String olderThan;
    @Option(title="older_than_timestamp", name={"--older-than-timestamp"}, description="Clear snapshots older than specified timestamp. It has to be a string in ISO format, for example '2022-12-03T10:15:30Z'")
    private String olderThanTimestamp;

    @Override
    public void execute(NodeProbe probe) {
        if (this.snapshotName.isEmpty() && !this.clearAllSnapshots) {
            throw new IllegalArgumentException("Specify snapshot name or --all");
        }
        if (!this.snapshotName.isEmpty() && this.clearAllSnapshots) {
            throw new IllegalArgumentException("Specify only one of snapshot name or --all");
        }
        if (this.olderThan != null && this.olderThanTimestamp != null) {
            throw new IllegalArgumentException("Specify only one of --older-than or --older-than-timestamp");
        }
        if (!this.snapshotName.isEmpty() && this.olderThan != null) {
            throw new IllegalArgumentException("Specifying snapshot name together with --older-than flag is not allowed");
        }
        if (!this.snapshotName.isEmpty() && this.olderThanTimestamp != null) {
            throw new IllegalArgumentException("Specifying snapshot name together with --older-than-timestamp flag is not allowed");
        }
        if (this.olderThanTimestamp != null) {
            try {
                Instant.parse(this.olderThanTimestamp);
            }
            catch (DateTimeParseException ex) {
                throw new IllegalArgumentException("Parameter --older-than-timestamp has to be a valid instant in ISO format.");
            }
        }
        Long olderThanInSeconds = null;
        if (this.olderThan != null) {
            olderThanInSeconds = new DurationSpec.LongSecondsBound(this.olderThan).toSeconds();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Requested clearing snapshot(s) for ");
        if (this.keyspaces.isEmpty()) {
            sb.append("[all keyspaces]");
        } else {
            sb.append('[').append(StringUtils.join(this.keyspaces, (String)", ")).append(']');
        }
        if (this.snapshotName.isEmpty()) {
            sb.append(" with [all snapshots]");
        } else {
            sb.append(" with snapshot name [").append(this.snapshotName).append(']');
        }
        if (olderThanInSeconds != null) {
            sb.append(" older than ").append(olderThanInSeconds).append(" seconds.");
        }
        if (this.olderThanTimestamp != null) {
            sb.append(" older than timestamp ").append(this.olderThanTimestamp);
        }
        probe.output().out.println(sb);
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (this.olderThan != null) {
                parameters.put("older_than", this.olderThan);
            }
            if (this.olderThanTimestamp != null) {
                parameters.put("older_than_timestamp", this.olderThanTimestamp);
            }
            probe.clearSnapshot(parameters, this.snapshotName, Iterables.toArray(this.keyspaces, String.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Error during clearing snapshots", e);
        }
    }
}

