/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public final class Throwables {
    public static boolean isCausedBy(Throwable t2, Predicate<Throwable> cause) {
        return cause.test(t2) || t2.getCause() != null && cause.test(t2.getCause());
    }

    public static boolean anyCauseMatches(Throwable t2, Predicate<Throwable> cause) {
        do {
            if (!cause.test(t2)) continue;
            return true;
        } while ((t2 = t2.getCause()) != null);
        return false;
    }

    public static <T extends Throwable> T merge(T existingFail, T newFail) {
        if (existingFail == null) {
            return newFail;
        }
        if (newFail == null) {
            return existingFail;
        }
        existingFail.addSuppressed(newFail);
        return existingFail;
    }

    public static void maybeFail(Throwable fail) {
        if (Throwables.failIfCanCast(fail, null)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> void maybeFail(Throwable fail, Class<T> checked) throws T {
        if (Throwables.failIfCanCast(fail, checked)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> boolean failIfCanCast(Throwable fail, Class<T> checked) throws T {
        if (fail == null) {
            return false;
        }
        if (fail instanceof Error) {
            throw (Error)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        if (fail instanceof InterruptedException) {
            throw new UncheckedInterruptedException((InterruptedException)fail);
        }
        if (checked != null && checked.isInstance(fail)) {
            throw (Throwable)checked.cast(fail);
        }
        return true;
    }

    @SafeVarargs
    public static <E extends Exception> void maybeFail(DiscreteAction<? extends E> ... actions) {
        Throwables.maybeFail(Throwables.perform(null, Stream.of(actions)));
    }

    @SafeVarargs
    public static <E extends Exception> void perform(DiscreteAction<? extends E> ... actions) throws E {
        Throwables.perform(Stream.of(actions));
    }

    public static <E extends Exception> void perform(Stream<? extends DiscreteAction<? extends E>> stream, DiscreteAction<? extends E> ... extra) throws E {
        Throwables.perform(Stream.concat(stream, Stream.of(extra)));
    }

    public static <E extends Exception> void perform(Stream<DiscreteAction<? extends E>> actions) throws E {
        Throwable fail = Throwables.perform(null, actions);
        if (Throwables.failIfCanCast(fail, null)) {
            throw (Exception)fail;
        }
    }

    public static Throwable perform(Throwable accumulate, DiscreteAction<?> ... actions) {
        return Throwables.perform(accumulate, Arrays.stream(actions));
    }

    public static Throwable perform(Throwable accumulate, Stream<? extends DiscreteAction<?>> actions) {
        return Throwables.perform(accumulate, actions.iterator());
    }

    public static Throwable perform(Throwable accumulate, Iterator<? extends DiscreteAction<?>> actions) {
        while (actions.hasNext()) {
            DiscreteAction<?> action = actions.next();
            try {
                action.perform();
            }
            catch (Throwable t2) {
                accumulate = Throwables.merge(accumulate, t2);
            }
        }
        return accumulate;
    }

    @SafeVarargs
    public static void perform(File against, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        Throwables.perform(against.path(), opType, actions);
    }

    @SafeVarargs
    public static void perform(String filePath, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        Throwables.maybeFail(Throwables.perform(null, filePath, opType, actions));
    }

    @SafeVarargs
    public static Throwable perform(Throwable accumulate, String filePath, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        return Throwables.perform(accumulate, filePath, opType, Arrays.stream(actions));
    }

    public static Throwable perform(Throwable accumulate, String filePath, FileOpType opType, Stream<DiscreteAction<? extends IOException>> actions) {
        return Throwables.perform(accumulate, actions.map(action -> () -> {
            try {
                action.perform();
            }
            catch (IOException e) {
                throw opType == FileOpType.WRITE ? new FSWriteError((Throwable)e, filePath) : new FSReadError((Throwable)e, filePath);
            }
        }));
    }

    public static void closeAndAddSuppressed(@Nonnull Throwable t2, AutoCloseable ... closeables) {
        Throwables.closeAndAddSuppressed(t2, Arrays.asList(closeables));
    }

    public static void closeNonNullAndAddSuppressed(@Nonnull Throwable t2, AutoCloseable ... closeables) {
        Throwables.closeAndAddSuppressed(t2, Iterables.filter(Arrays.asList(closeables), Objects::nonNull));
    }

    public static void closeAndAddSuppressed(@Nonnull Throwable accumulate, Iterable<AutoCloseable> closeables) {
        Preconditions.checkNotNull(accumulate);
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                accumulate.addSuppressed(ex);
            }
        }
    }

    public static Throwable close(Throwable accumulate, AutoCloseable ... closeables) {
        return Throwables.close(accumulate, Arrays.asList(closeables));
    }

    public static Throwable close(Throwable accumulate, Iterable<? extends AutoCloseable> closeables) {
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Throwable t2) {
                accumulate = Throwables.merge(accumulate, t2);
            }
        }
        return accumulate;
    }

    public static Optional<IOException> extractIOExceptionCause(Throwable t2) {
        if (t2 instanceof IOException) {
            return Optional.of((IOException)t2);
        }
        Throwable cause = t2;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof IOException)) continue;
            return Optional.of((IOException)cause);
        }
        return Optional.empty();
    }

    public static Throwable unwrapped(Throwable t2) {
        Throwable unwrapped = t2;
        while (unwrapped instanceof CompletionException || unwrapped instanceof ExecutionException || unwrapped instanceof InvocationTargetException) {
            unwrapped = unwrapped.getCause();
        }
        return unwrapped == null ? new RuntimeException("Got wrapping exception not wrapping anything", t2) : unwrapped;
    }

    public static RuntimeException unchecked(Throwable t2) {
        return t2 instanceof RuntimeException ? (RuntimeException)t2 : (t2 instanceof InterruptedException ? new UncheckedInterruptedException((InterruptedException)t2) : new RuntimeException(t2));
    }

    public static RuntimeException throwAsUncheckedException(Throwable t2) {
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        throw Throwables.unchecked(t2);
    }

    public static RuntimeException cleaned(Throwable t2) {
        return Throwables.unchecked(Throwables.unwrapped(t2));
    }

    @VisibleForTesting
    public static void assertAnyCause(Throwable err, Class<? extends Throwable> cause) {
        if (!Throwables.anyCauseMatches(err, cause::isInstance)) {
            throw new AssertionError("The exception is not caused by " + cause.getName(), err);
        }
    }

    public static interface DiscreteAction<E extends Exception> {
        public void perform() throws E;
    }

    public static enum FileOpType {
        READ,
        WRITE;

    }
}

