/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.logging;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.audit.FileAuditLogger;
import org.apache.cassandra.db.virtual.LogMessagesTable;
import org.apache.cassandra.db.virtual.VirtualKeyspace;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;

public final class VirtualTableAppender
extends AppenderBase<LoggingEvent> {
    public static final String APPENDER_NAME = "CQLLOG";
    private static final Set<String> forbiddenLoggers = ImmutableSet.of(FileAuditLogger.class.getName());
    private LogMessagesTable logs;
    private final List<LoggingEvent> messageBuffer = new LinkedList<LoggingEvent>();

    @Override
    protected void append(LoggingEvent eventObject) {
        if (!forbiddenLoggers.contains(eventObject.getLoggerName())) {
            if (this.logs == null) {
                this.logs = this.getVirtualTable();
                if (this.logs == null) {
                    this.addToBuffer(eventObject);
                } else {
                    this.logs.add(eventObject);
                }
            } else {
                this.logs.add(eventObject);
            }
        }
    }

    @Override
    public void stop() {
        this.messageBuffer.clear();
        super.stop();
    }

    public void flushBuffer() {
        Optional.ofNullable(this.getVirtualTable()).ifPresent(vtable -> {
            this.messageBuffer.forEach(vtable::add);
            this.messageBuffer.clear();
        });
    }

    private LogMessagesTable getVirtualTable() {
        VirtualKeyspace keyspace = VirtualKeyspaceRegistry.instance.getKeyspaceNullable("system_views");
        if (keyspace == null) {
            return null;
        }
        Optional<VirtualTable> logsTable = keyspace.tables().stream().filter(vt -> vt.name().equals("system_logs")).findFirst();
        if (!logsTable.isPresent()) {
            return null;
        }
        VirtualTable vt2 = logsTable.get();
        if (!(vt2 instanceof LogMessagesTable)) {
            throw new IllegalStateException(String.format("Virtual table %s.%s is not backed by an instance of %s but by %s", "system_views", "system_logs", LogMessagesTable.class.getName(), vt2.getClass().getName()));
        }
        return (LogMessagesTable)vt2;
    }

    private void addToBuffer(LoggingEvent eventObject) {
        if (this.messageBuffer.size() < 50000) {
            this.messageBuffer.add(eventObject);
        }
    }
}

