/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.vint;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class VIntCoding {
    protected static final FastThreadLocal<byte[]> encodingBuffer = new FastThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[9];
        }
    };
    public static final int MAX_SIZE = 10;

    public static long readUnsignedVInt(DataInput input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.readByte();
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static void skipUnsignedVInt(DataInputPlus input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte < 0) {
            input.skipBytesFully(VIntCoding.numberOfExtraBytesToRead(firstByte));
        }
    }

    public static int getUnsignedVInt32(ByteBuffer input, int readerIndex) {
        return VIntCoding.checkedCast(VIntCoding.getUnsignedVInt(input, readerIndex));
    }

    public static int getVInt32(ByteBuffer input, int readerIndex) {
        return VIntCoding.checkedCast(VIntCoding.decodeZigZag64(VIntCoding.getUnsignedVInt(input, readerIndex)));
    }

    public static long getVInt(ByteBuffer input, int readerIndex) {
        return VIntCoding.decodeZigZag64(VIntCoding.getUnsignedVInt(input, readerIndex));
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex) {
        return VIntCoding.getUnsignedVInt(input, readerIndex, input.limit());
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex, int readerLimit) {
        byte firstByte;
        if (readerIndex < 0) {
            throw new IllegalArgumentException("Reader index should be non-negative, but was " + readerIndex);
        }
        if (readerIndex >= readerLimit) {
            return -1L;
        }
        if ((firstByte = input.get(readerIndex++)) >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        if (readerIndex + size > readerLimit) {
            return -1L;
        }
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.get(readerIndex++);
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static <V> int getUnsignedVInt32(V input, ValueAccessor<V> accessor, int readerIndex) {
        return VIntCoding.checkedCast(VIntCoding.getUnsignedVInt(input, accessor, readerIndex));
    }

    public static <V> int getVInt32(V input, ValueAccessor<V> accessor, int readerIndex) {
        return VIntCoding.checkedCast(VIntCoding.decodeZigZag64(VIntCoding.getUnsignedVInt(input, accessor, readerIndex)));
    }

    public static <V> long getVInt(V input, ValueAccessor<V> accessor, int readerIndex) {
        return VIntCoding.decodeZigZag64(VIntCoding.getUnsignedVInt(input, accessor, readerIndex));
    }

    public static <V> long getUnsignedVInt(V input, ValueAccessor<V> accessor, int readerIndex) {
        return VIntCoding.getUnsignedVInt(input, accessor, readerIndex, accessor.size(input));
    }

    public static <V> long getUnsignedVInt(V input, ValueAccessor<V> accessor, int readerIndex, int readerLimit) {
        byte firstByte;
        if (readerIndex < 0) {
            throw new IllegalArgumentException("Reader index should be non-negative, but was " + readerIndex);
        }
        if (readerIndex >= readerLimit) {
            return -1L;
        }
        if ((firstByte = accessor.getByte(input, readerIndex++)) >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        if (readerIndex + size > readerLimit) {
            return -1L;
        }
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = accessor.getByte(input, readerIndex++);
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static int computeUnsignedVIntSize(ByteBuffer input, int readerIndex) {
        return VIntCoding.computeUnsignedVIntSize(input, readerIndex, input.limit());
    }

    public static int computeUnsignedVIntSize(ByteBuffer input, int readerIndex, int readerLimit) {
        if (readerIndex >= readerLimit) {
            return -1;
        }
        byte firstByte = input.get(readerIndex);
        return 1 + (firstByte >= 0 ? 0 : VIntCoding.numberOfExtraBytesToRead(firstByte));
    }

    public static long readVInt(DataInput input) throws IOException {
        return VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input));
    }

    public static int readVInt32(DataInput input) throws IOException {
        return VIntCoding.checkedCast(VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input)));
    }

    public static int readUnsignedVInt32(DataInput input) throws IOException {
        return VIntCoding.checkedCast(VIntCoding.readUnsignedVInt(input));
    }

    public static int firstByteValueMask(int extraBytesToRead) {
        return 255 >> extraBytesToRead;
    }

    public static int encodeExtraBytesToRead(int extraBytesToRead) {
        return ~VIntCoding.firstByteValueMask(extraBytesToRead);
    }

    public static int numberOfExtraBytesToRead(int firstByte) {
        return Integer.numberOfLeadingZeros(~firstByte) - 24;
    }

    @Deprecated(since="5.0")
    public static void writeUnsignedVInt(int value, DataOutputPlus output) throws IOException {
        throw new UnsupportedOperationException("Use writeUnsignedVInt32/readUnsignedVInt32");
    }

    public static void writeUnsignedVInt(long value, DataOutputPlus output) throws IOException {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.writeByte((int)value);
        } else if (size < 9) {
            int shift = 8 - size << 3;
            int extraBytes = size - 1;
            long mask = (long)VIntCoding.encodeExtraBytesToRead(extraBytes) << 56;
            long register = value << shift | mask;
            output.writeMostSignificantBytes(register, size);
        } else if (size == 9) {
            output.write(-1);
            output.writeLong(value);
        } else {
            throw new AssertionError();
        }
    }

    public static void writeUnsignedVInt32(int value, DataOutputPlus output) throws IOException {
        VIntCoding.writeUnsignedVInt((long)value, output);
    }

    @Deprecated(since="5.0")
    public static void writeUnsignedVInt(int value, ByteBuffer output) throws IOException {
        throw new UnsupportedOperationException("Use writeUnsignedVInt32/getUnsignedVInt32");
    }

    public static void writeUnsignedVInt(long value, ByteBuffer output) {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.put((byte)value);
        } else if (size < 9) {
            int pos;
            int limit = output.limit();
            if (limit - (pos = output.position()) >= 8) {
                int shift = 8 - size << 3;
                int extraBytes = size - 1;
                long mask = (long)VIntCoding.encodeExtraBytesToRead(extraBytes) << 56;
                long register = value << shift | mask;
                output.putLong(pos, register);
                output.position(pos + size);
            } else {
                output.put(VIntCoding.encodeUnsignedVInt(value, size), 0, size);
            }
        } else if (size == 9) {
            output.put((byte)-1);
            output.putLong(value);
        } else {
            throw new AssertionError();
        }
    }

    public static <V> int writeVInt(long value, V output, int offset, ValueAccessor<V> accessor) {
        return VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output, offset, accessor);
    }

    public static <V> int writeVInt32(int value, V output, int offset, ValueAccessor<V> accessor) {
        return VIntCoding.writeVInt(value, output, offset, accessor);
    }

    public static <V> int writeUnsignedVInt32(int value, V output, int offset, ValueAccessor<V> accessor) {
        return VIntCoding.writeUnsignedVInt(value, output, offset, accessor);
    }

    public static <V> int writeUnsignedVInt(long value, V output, int offset, ValueAccessor<V> accessor) {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        int written = 0;
        if (size == 1) {
            written += accessor.putByte(output, offset, (byte)value);
        } else if (size < 9) {
            if (accessor.remaining(output, offset) >= 8) {
                int shift = 8 - size << 3;
                int extraBytes = size - 1;
                long mask = (long)VIntCoding.encodeExtraBytesToRead(extraBytes) << 56;
                long register = value << shift | mask;
                accessor.putLong(output, offset, register);
                written += size;
            } else {
                written += accessor.putBytes(output, offset, VIntCoding.encodeUnsignedVInt(value, size), 0, size);
            }
        } else if (size == 9) {
            written += accessor.putByte(output, offset, (byte)-1);
            written += accessor.putLong(output, offset + written, value);
        } else {
            throw new AssertionError();
        }
        return written;
    }

    public static void writeUnsignedVInt32(int value, ByteBuffer output) {
        VIntCoding.writeUnsignedVInt((long)value, output);
    }

    @Deprecated(since="5.0")
    public static void writeVInt(int value, DataOutputPlus output) throws IOException {
        throw new UnsupportedOperationException("Use writeVInt32/readVInt32");
    }

    public static void writeVInt(long value, DataOutputPlus output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    public static void writeVInt32(int value, DataOutputPlus output) throws IOException {
        VIntCoding.writeVInt((long)value, output);
    }

    @Deprecated(since="5.0")
    public static void writeVInt(int value, ByteBuffer output) {
        throw new UnsupportedOperationException("Use writeVInt32/getVInt32");
    }

    public static void writeVInt(long value, ByteBuffer output) {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    public static void writeVInt32(int value, ByteBuffer output) {
        VIntCoding.writeVInt((long)value, output);
    }

    private static byte[] encodeUnsignedVInt(long value, int size) {
        int extraBytes;
        byte[] encodingSpace = encodingBuffer.get();
        for (int i = extraBytes = size - 1; i >= 0; --i) {
            encodingSpace[i] = (byte)value;
            value >>= 8;
        }
        encodingSpace[0] = (byte)(encodingSpace[0] | VIntCoding.encodeExtraBytesToRead(extraBytes));
        return encodingSpace;
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int computeVIntSize(long param) {
        return VIntCoding.computeUnsignedVIntSize(VIntCoding.encodeZigZag64(param));
    }

    public static int computeUnsignedVIntSize(long value) {
        int magnitude = Long.numberOfLeadingZeros(value | 1L);
        return 639 - magnitude * 9 >> 6;
    }

    public static int checkedCast(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new VIntOutOfRangeException(value);
        }
        return result;
    }

    public static class VIntOutOfRangeException
    extends RuntimeException {
        public final long value;

        private VIntOutOfRangeException(long value) {
            super(value + " is out of range for a 32-bit integer");
            this.value = value;
        }
    }
}

