/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.testcontainer;

import com.adobe.testing.s3mock.testcontainers.S3MockContainer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.testcontainer.LocalStorageTransportExtension;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.apache.cassandra.sidecar.config.yaml.S3ClientConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.S3ProxyConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SidecarConfigurationImpl;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BulkWriteS3CompatModeSimpleTest
extends SharedClusterSparkIntegrationTestBase {
    public static final String BUCKET_NAME = "sbw-bucket";
    private static final QualifiedName TABLE_NAME = new QualifiedName("spark_test", BulkWriteS3CompatModeSimpleTest.class.getSimpleName().toLowerCase());
    private S3MockContainer s3Mock;

    BulkWriteS3CompatModeSimpleTest() {
    }

    protected void afterClusterProvisioned() {
        super.afterClusterProvisioned();
        this.s3Mock = new S3MockContainer("2.17.0").withInitialBuckets(BUCKET_NAME);
        this.s3Mock.start();
        Assertions.assertThat((boolean)this.s3Mock.isRunning()).isTrue();
    }

    @Override
    protected void afterClusterShutdown() {
        this.s3Mock.stop();
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        this.createTestTable(TABLE_NAME, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
    }

    protected Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> configurationOverrides() {
        return builder -> {
            S3ClientConfigurationImpl s3ClientConfig = new S3ClientConfigurationImpl("s3-client", 4, S3ClientConfigurationImpl.DEFAULT_THREAD_KEEP_ALIVE, 0x500000, S3ClientConfigurationImpl.DEFAULT_API_CALL_TIMEOUT, this.buildTestS3ProxyConfig());
            builder.s3ClientConfiguration((S3ClientConfiguration)s3ClientConfig);
            return builder;
        };
    }

    @Override
    protected void beforeTestStart() {
        super.beforeTestStart();
        this.waitForSchemaReady(30L, TimeUnit.SECONDS);
    }

    private S3ProxyConfiguration buildTestS3ProxyConfig() {
        return new S3MockProxyConfigurationImpl(this.s3Mock.getHttpEndpoint());
    }

    @Test
    void testS3CompatBulkWrite() {
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        ImmutableMap s3CompatOptions = ImmutableMap.of((Object)"data_transport", (Object)"S3_COMPAT", (Object)"data_transport_extension_class", (Object)LocalStorageTransportExtension.class.getCanonicalName(), (Object)"storage_client_endpoint_override", (Object)this.s3Mock.getHttpEndpoint());
        this.bulkWriterDataFrameWriter(df, TABLE_NAME, (Map<String, String>)s3CompatOptions).save();
        this.sparkTestUtils.validateWrites(df.collectAsList(), this.queryAllData(TABLE_NAME));
    }

    public static class S3MockProxyConfigurationImpl
    extends S3ProxyConfigurationImpl {
        S3MockProxyConfigurationImpl(String endpointOverride) {
            super(null, null, null, endpointOverride);
        }
    }
}

