/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.RangeTombstone;
import org.apache.cassandra.cdc.msg.RangeTombstoneBuilder;
import org.apache.cassandra.cdc.msg.Value;
import org.jetbrains.annotations.Nullable;

public class CdcEventBuilder {
    @Nullable
    protected List<Value> partitionKeys = null;
    @Nullable
    protected List<Value> clusteringKeys = null;
    @Nullable
    protected List<Value> staticColumns = null;
    @Nullable
    protected List<Value> valueColumns = null;
    protected long maxTimestampMicros = Long.MIN_VALUE;
    @Nullable
    protected CdcEvent.TimeToLive timeToLive = null;
    @Nullable
    protected Map<String, List<ByteBuffer>> tombstonedCellsInComplex = null;
    @Nullable
    protected List<RangeTombstone> rangeTombstoneList = null;
    @Nullable
    protected RangeTombstoneBuilder<?> rangeTombstoneBuilder = null;
    public boolean track;
    @Nullable
    public String trackingId;
    public String keyspace;
    public String table;
    public CdcEvent.Kind kind;
    protected CassandraSource cassandraSource;

    protected CdcEventBuilder(CdcEvent.Kind kind, String keyspace, String table, String trackingId, CassandraSource cassandraSource) {
        this.kind = kind;
        this.keyspace = keyspace;
        this.table = table;
        this.trackingId = trackingId;
        this.track = trackingId != null;
        this.cassandraSource = cassandraSource;
    }

    public static CdcEventBuilder of(CdcEvent.Kind kind, String keyspace, String table) {
        return CdcEventBuilder.of(kind, keyspace, table, null, CassandraSource.DEFAULT);
    }

    public static CdcEventBuilder of(CdcEvent.Kind kind, String keyspace, String table, String trackingId, CassandraSource cassandraSource) {
        return new CdcEventBuilder(kind, keyspace, table, trackingId, cassandraSource);
    }

    public void setPartitionKeys(@Nullable List<Value> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void setClusteringKeys(@Nullable List<Value> clusteringKeys) {
        this.clusteringKeys = clusteringKeys;
    }

    public void setStaticColumns(@Nullable List<Value> staticColumns) {
        this.staticColumns = staticColumns;
    }

    public void setValueColumns(@Nullable List<Value> valueColumns) {
        this.valueColumns = valueColumns;
    }

    public void setMaxTimestampMicros(long maxTimestampMicros) {
        this.maxTimestampMicros = maxTimestampMicros;
    }

    public void setTTL(int ttlInSec, int expirationTimeInSec) {
        if (this.timeToLive != null) {
            return;
        }
        this.setTimeToLive(new CdcEvent.TimeToLive(ttlInSec, expirationTimeInSec));
    }

    public void setTimeToLive(CdcEvent.TimeToLive timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTombstonedCellsInComplex(Map<String, List<ByteBuffer>> tombstonedCellsInComplex) {
        this.tombstonedCellsInComplex = tombstonedCellsInComplex;
    }

    public void setRangeTombstoneList(List<RangeTombstone> rangeTombstoneList) {
        this.rangeTombstoneList = rangeTombstoneList;
    }

    public void setRangeTombstoneBuilder(RangeTombstoneBuilder<?> rangeTombstoneBuilder) {
        this.rangeTombstoneBuilder = rangeTombstoneBuilder;
    }

    public void setTrack(boolean track) {
        this.track = track;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
        this.track = trackingId != null;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setKind(CdcEvent.Kind kind) {
        this.kind = kind;
    }

    public void setCassandraSource(CassandraSource cassandraSource) {
        this.cassandraSource = cassandraSource;
    }

    public void addCellTombstoneInComplex(String columnName, ByteBuffer key) {
        if (this.tombstonedCellsInComplex == null) {
            this.tombstonedCellsInComplex = new HashMap<String, List<ByteBuffer>>();
        }
        List tombstones = this.tombstonedCellsInComplex.computeIfAbsent(columnName, k -> new ArrayList());
        tombstones.add(key);
    }

    protected void updateMaxTimestamp(long timestamp) {
        this.maxTimestampMicros = Math.max(this.maxTimestampMicros, timestamp);
    }

    public void validateRangeTombstoneMarkers() {
        if (this.rangeTombstoneList == null) {
            return;
        }
        Preconditions.checkState((!this.rangeTombstoneBuilder.hasIncompleteRange() ? 1 : 0) != 0, (Object)"The last range tombstone is not closed");
    }

    public CdcEvent build() {
        this.validateRangeTombstoneMarkers();
        return new CdcEvent(this);
    }
}

