/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.Optional;
import java.util.function.Function;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.sparksql.Cell;
import org.apache.cassandra.spark.sparksql.RowBuilder;

public class FullRowBuilder<T>
implements RowBuilder<T> {
    static final Object[] EMPTY_RESULT = new Object[0];
    protected final int numColumns;
    protected final int numCells;
    protected final boolean hasProjectedValueColumns;
    protected int extraColumns;
    protected Object[] result;
    protected int count;
    private final CqlTable cqlTable;
    protected final Function<Object[], T> rowBuilder;

    FullRowBuilder(CqlTable cqlTable, boolean hasProjectedValueColumns, Function<Object[], T> rowBuilder) {
        this.cqlTable = cqlTable;
        this.numColumns = cqlTable.numFields();
        this.hasProjectedValueColumns = hasProjectedValueColumns;
        this.numCells = cqlTable.numNonValueColumns() + (hasProjectedValueColumns ? 1 : 0);
        this.rowBuilder = rowBuilder;
    }

    @Override
    public CqlTable getCqlTable() {
        return this.cqlTable;
    }

    @Override
    public void reset() {
        this.count = 0;
        int totalColumns = this.numColumns + this.extraColumns;
        this.result = totalColumns != 0 ? new Object[totalColumns] : EMPTY_RESULT;
    }

    @Override
    public boolean isFirstCell() {
        return this.count == 0;
    }

    @Override
    public void copyKeys(Cell cell) {
        int length = !this.hasProjectedValueColumns ? cell.values.length : cell.values.length - 1;
        System.arraycopy(cell.values, 0, this.result, 0, length);
        this.count += length;
    }

    @Override
    public void copyValue(Cell cell) {
        this.result[cell.position] = cell.values[cell.values.length - 1];
        ++this.count;
    }

    @Override
    public Object[] array() {
        return this.result;
    }

    @Override
    public int columnsCount() {
        return this.numColumns;
    }

    @Override
    public boolean hasRegularValueColumn() {
        return this.hasProjectedValueColumns;
    }

    @Override
    public int expandRow(int extraColumns) {
        this.extraColumns = extraColumns;
        return this.numColumns;
    }

    @Override
    public boolean hasMoreCells() {
        return this.count < this.numColumns;
    }

    @Override
    public void onCell(Cell cell) {
        assert (0 < cell.values.length && cell.values.length <= this.numCells);
    }

    @Override
    public int fieldIndex(String name) {
        return Optional.ofNullable(this.cqlTable.getField(name)).map(CqlField::position).orElse(-1);
    }

    @Override
    public T build() {
        return this.rowBuilder.apply(this.result);
    }
}

