/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.sparksql.Cell;
import org.apache.cassandra.spark.sparksql.FullRowBuilder;
import org.jetbrains.annotations.NotNull;

public class PartialRowBuilder<T>
extends FullRowBuilder<T> {
    private final int[] positionsMap;
    private final boolean hasAllNonValueColumns;
    protected final String[] requiredSchema;
    private final Map<String, Integer> columnIndex;

    public PartialRowBuilder(@NotNull String[] requiredSchema, CqlTable table, boolean hasProjectedValueColumns, Function<Object[], T> rowBuilder) {
        super(table, hasProjectedValueColumns, rowBuilder);
        Objects.requireNonNull(requiredSchema, "requiredColumns must be non-null to use PartialRowBuilder");
        this.requiredSchema = requiredSchema;
        this.columnIndex = new HashMap<String, Integer>(requiredSchema.length);
        for (int i = 0; i < requiredSchema.length; ++i) {
            this.columnIndex.put(requiredSchema[i], i);
        }
        Set requiredColumns = Arrays.stream(requiredSchema).collect(Collectors.toSet());
        this.hasAllNonValueColumns = table.fields().stream().filter(CqlField::isNonValueColumn).map(CqlField::name).allMatch(requiredColumns::contains);
        this.positionsMap = IntStream.range(0, table.numFields()).map(position -> -1).toArray();
        int position2 = 0;
        for (String fieldName : requiredSchema) {
            CqlField field = table.getField(fieldName);
            if (field == null) continue;
            this.positionsMap[field.position()] = position2++;
        }
    }

    @Override
    public void reset() {
        this.count = 0;
        int totalColumns = this.requiredSchema.length;
        this.result = totalColumns > 0 ? new Object[totalColumns] : EMPTY_RESULT;
    }

    @Override
    public int fieldIndex(String name) {
        return this.requiredSchema != null ? this.columnIndex.get(name).intValue() : super.fieldIndex(name);
    }

    @Override
    public void copyKeys(Cell cell) {
        if (this.hasAllNonValueColumns) {
            super.copyKeys(cell);
            return;
        }
        int length = !this.hasProjectedValueColumns ? cell.values.length : cell.values.length - 1;
        for (int index = 0; index < length; ++index) {
            int position = this.positionsMap[index];
            if (position < 0) continue;
            this.result[position] = cell.values[index];
        }
        this.count += length;
    }

    @Override
    public void copyValue(Cell cell) {
        int position = this.positionsMap[cell.position];
        if (position >= 0) {
            this.result[position] = cell.values[cell.values.length - 1];
        }
        ++this.count;
    }
}

