/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileOutputStream
extends FilterOutputStream {
    static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    public static final String TMP_EXTENSION = ".tmp";
    private final File outFile;
    private final File tmpFile;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public static File getTemporaryFile(File outFile) {
        return new File(outFile.getParentFile(), outFile.getName() + TMP_EXTENSION);
    }

    public AtomicFileOutputStream(File outFile) throws FileNotFoundException {
        this(outFile, AtomicFileOutputStream.getTemporaryFile(outFile));
    }

    public AtomicFileOutputStream(File outFile, File tmpFile) throws FileNotFoundException {
        super(new FileOutputStream(tmpFile));
        this.outFile = outFile.getAbsoluteFile();
        this.tmpFile = tmpFile.getAbsoluteFile();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block9: {
            block10: {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                boolean forced = false;
                boolean closed = false;
                try {
                    this.flush();
                    ((FileOutputStream)this.out).getChannel().force(true);
                    forced = true;
                    super.close();
                    closed = true;
                    boolean renamed = this.tmpFile.renameTo(this.outFile);
                    if (!renamed) {
                        if (this.outFile.exists() && !this.outFile.delete()) {
                            throw new IOException("Could not delete original file " + this.outFile);
                        }
                        FileUtils.move(this.tmpFile, this.outFile);
                    }
                    if (closed) break block9;
                    if (forced) break block10;
                }
                catch (Throwable throwable) {
                    if (!closed) {
                        if (!forced) {
                            IOUtils.cleanup(LOG, this.out);
                        }
                        if (!this.tmpFile.delete()) {
                            LOG.warn("Unable to delete tmp file " + this.tmpFile);
                        }
                    }
                    throw throwable;
                }
                IOUtils.cleanup(LOG, this.out);
            }
            if (!this.tmpFile.delete()) {
                LOG.warn("Unable to delete tmp file " + this.tmpFile);
            }
        }
    }

    public void abort() {
        if (this.isClosed.get()) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException ioe) {
            LOG.warn("Unable to abort file " + this.tmpFile, (Throwable)ioe);
        }
        finally {
            if (!this.tmpFile.delete()) {
                LOG.warn("Unable to delete tmp file during abort " + this.tmpFile);
            }
        }
    }
}

