/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.reflect.DynFields;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomShuffleDependencyUtils {
    private static final Logger logger = LoggerFactory.getLogger(CustomShuffleDependencyUtils.class);
    private static final DynFields.UnboundField<StructType> SCHEMA_FIELD = DynFields.builder().hiddenImpl(ShuffleDependency.class, "schema").defaultAlwaysNull().build();

    public static StructType getSchema(ShuffleDependency<?, ?, ?> dep) {
        StructType schema = null;
        try {
            schema = SCHEMA_FIELD.bind(dep).get();
        }
        catch (Exception e) {
            logger.error("Failed to bind shuffle dependency of shuffle {}.", (Object)dep.shuffleId(), (Object)e);
        }
        if (schema == null) {
            logger.warn("Failed to get Schema of shuffle {}, columnar shuffle won't work properly.", (Object)dep.shuffleId());
        }
        return schema;
    }
}

