/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class PropertiesTag
extends TagSupport {
    private String file;
    private String uri;
    private String var;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTag(XMLOutput output) throws JellyTagException {
        Properties props;
        block17: {
            if (this.file == null && this.uri == null) {
                throw new JellyTagException("This tag must define a 'file' or 'uri' attribute");
            }
            InputStream is = null;
            if (this.file != null) {
                File f = new File(this.file);
                if (!f.exists()) {
                    throw new JellyTagException("file: " + this.file + " does not exist!");
                }
                try {
                    is = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new JellyTagException((Throwable)e);
                }
            } else {
                is = this.context.getResourceAsStream(this.uri);
                if (is == null) {
                    throw new JellyTagException("Could not find: " + this.uri);
                }
            }
            props = new Properties();
            try {
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new JellyTagException("properties tag could not load from file", (Throwable)e);
                }
                Object var6_7 = null;
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioe) {}
            is.close();
        }
        if (this.var != null) {
            this.context.setVariable(this.var, (Object)props);
            return;
        }
        Enumeration<?> propsEnum = props.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            String value = props.getProperty(key);
            this.context.setVariable(key, (Object)value);
        }
        return;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

