/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ClassFieldMap {
    private static final boolean debugReflection = false;
    private final Logger log;
    private final Class clazz;
    private final Map fieldCache;

    public ClassFieldMap(Class clazz, Logger logger) {
        this.clazz = clazz;
        this.log = logger;
        this.fieldCache = this.createFieldCache();
    }

    public Class getCachedClass() {
        return this.clazz;
    }

    public Field findField(String string) {
        return (Field)this.fieldCache.get(string);
    }

    private Map createFieldCache() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        for (Class clazz = this.getCachedClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] classArray;
            if (Modifier.isPublic(clazz.getModifiers())) {
                this.populateFieldCacheWith(concurrentHashMap, clazz);
            }
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                this.populateFieldCacheWithInterface(concurrentHashMap, clazz2);
            }
        }
        return concurrentHashMap;
    }

    private void populateFieldCacheWithInterface(Map map, Class clazz) {
        Class<?>[] classArray;
        if (Modifier.isPublic(clazz.getModifiers())) {
            this.populateFieldCacheWith(map, clazz);
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            this.populateFieldCacheWithInterface(map, clazz2);
        }
    }

    private void populateFieldCacheWith(Map map, Class clazz) {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                int n = field.getModifiers();
                if (!Modifier.isPublic(n)) continue;
                map.put(field.getName(), field);
            }
        }
        catch (SecurityException securityException) {
            this.log.debug("While accessing fields of {}:", (Object)clazz, (Object)securityException);
        }
    }
}

