/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.control.Controller;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.SourceTransformerDefinition;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

public class LoadAllSourceFilesTransformer
implements SourceTransformer {
    private static Log log = LogFactory.getLog(LoadAllSourceFilesTransformer.class);
    private String addTo;
    private String newElement;
    private boolean combineSources;

    @Override
    public Object transform(Object rootObject, ControllerState controllerState) throws SourceTransformerException {
        if (!(rootObject instanceof SourceElement)) {
            throw new SourceTransformerException("rootObject is not a SourceElement but has the class " + rootObject.getClass().getName());
        }
        SourceElement root = (SourceElement)rootObject;
        Output output = controllerState.getOutput();
        log.debug((Object)("adding all sources of output " + output.getName() + " to current source tree at element " + this.addTo));
        List<SourceElement> sourceElementList = SourcePath.getElementsFromRoot(root, this.addTo);
        if (sourceElementList.isEmpty()) {
            throw new SourceTransformerException("Source element " + this.addTo + " does not exist");
        }
        SourceElement addToSourceElement = sourceElementList.get(0);
        UnitConfiguration unitConfiguration = controllerState.getUnitConfiguration();
        ConfigurationHandlers configurationHandlers = unitConfiguration.getConfigurationHandlers();
        Controller helperController = new Controller();
        SourceElement newSourceElement = new SourceElement(this.newElement);
        boolean newSourceElementAdded = false;
        try {
            SourceProvider sourceProvider = controllerState.getSourceProvider().copy();
            sourceProvider.init(configurationHandlers, controllerState);
            while (sourceProvider.hasNext()) {
                Source source = (Source)sourceProvider.next();
                SourceElement rootElement = source.getRootElement();
                SourceProcessConfiguration sourceProcessConfiguration = output.getSourceProcessConfiguration();
                List<SourceTransformerDefinition> transformerDefinitions = sourceProcessConfiguration.getTransformerDefinitions();
                transformerDefinitions = new ArrayList<SourceTransformerDefinition>(transformerDefinitions);
                Iterator<SourceTransformerDefinition> transformerDefinitionIt = transformerDefinitions.iterator();
                while (transformerDefinitionIt.hasNext()) {
                    SourceTransformerDefinition transformerDefinition = transformerDefinitionIt.next();
                    if (!this.equals(transformerDefinition.getSourceTransformer())) continue;
                    transformerDefinitionIt.remove();
                }
                rootElement = (SourceElement)helperController.transformSource(rootElement, transformerDefinitions, controllerState);
                newSourceElement.getChildren().add(rootElement);
                if (!newSourceElementAdded) {
                    addToSourceElement.getChildren().add(newSourceElement);
                    newSourceElementAdded = true;
                }
                if (this.combineSources) continue;
                newSourceElement = new SourceElement(this.newElement);
                newSourceElementAdded = false;
            }
        }
        catch (ConfigurationException e) {
            throw new SourceTransformerException(e);
        }
        catch (SourceException e) {
            throw new SourceTransformerException(e);
        }
        log.debug((Object)"additional sources loaded.");
        return root;
    }

    public String getAddTo() {
        return this.addTo;
    }

    public void setAddTo(String addTo) {
        this.addTo = addTo;
    }

    public String getNewElement() {
        return this.newElement;
    }

    public void setNewElement(String newElement) {
        this.newElement = newElement;
    }

    public boolean isCombineSources() {
        return this.combineSources;
    }

    public void setCombineSources(boolean combineSources) {
        this.combineSources = combineSources;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.addTo).append(this.combineSources).append((Object)this.newElement).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LoadAllSourceFilesTransformer other = (LoadAllSourceFilesTransformer)obj;
        return new EqualsBuilder().append((Object)other.addTo, (Object)this.addTo).append(other.combineSources, this.combineSources).append((Object)other.newElement, (Object)this.newElement).isEquals();
    }
}

