/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.InheritanceAttributeName;
import org.apache.torque.templates.transformer.om.TableAttributeName;

public class OMInheritanceTransformer {
    private static Logger logger = LogManager.getLogger(OMInheritanceTransformer.class);

    public void transform(SourceElement inheritanceElement, ControllerState controllerState) throws SourceTransformerException {
        Object beanClassName;
        if (!TorqueSchemaElementName.INHERITANCE.getName().equals(inheritanceElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + inheritanceElement.getName());
        }
        String key = (String)inheritanceElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.KEY);
        if (key == null) {
            throw new IllegalArgumentException("Attribute \"" + String.valueOf((Object)TorqueSchemaAttributeName.KEY) + "\" not set in Element " + String.valueOf((Object)TorqueSchemaElementName.INHERITANCE));
        }
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.CLASSKEY_CONSTANT, (Object)("CLASSKEY_" + key.toUpperCase()));
        SourceElement tableElement = inheritanceElement.getParent().getParent();
        String className = (String)inheritanceElement.getAttribute(TorqueSchemaAttributeName.CLASS.getName());
        if (className == null) {
            className = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME);
        }
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.CLASS_NAME, (Object)className);
        String tablePackage = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_PACKAGE);
        String thisElementPackage = (String)inheritanceElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PACKAGE);
        String packageName = this.updatePackage(thisElementPackage, tablePackage);
        logger.debug("key: {}: package: {} from package: {}, table package: {}", (Object)key, (Object)packageName, (Object)thisElementPackage, (Object)tablePackage);
        inheritanceElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.PACKAGE, (Object)packageName);
        String extendsAttribute = (String)inheritanceElement.getAttribute(TorqueSchemaAttributeName.EXTENDS.getName());
        Object beanExtends = (String)inheritanceElement.getAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS);
        if (extendsAttribute == null) {
            extendsAttribute = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME);
            inheritanceElement.setAttribute(TorqueSchemaAttributeName.EXTENDS.getName(), (Object)extendsAttribute);
            beanClassName = tableElement.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME).toString();
            logger.debug("key: {}: extends from default {} (not set in element) and beanClassName:{}..", (Object)key, (Object)extendsAttribute, beanClassName);
            inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS, beanClassName);
        } else if (beanExtends == null) {
            String unqualifiedClassname;
            int lastDot = extendsAttribute.lastIndexOf(".");
            String tableBeanPackage = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.BEAN_PACKAGE);
            Object extendPackage = extendsAttribute.substring(0, lastDot);
            String beanClassNameSuffix = controllerState.getOption("torque.om.className.beanClassNameSuffix").toString();
            if (((String)extendPackage).equals(packageName) && lastDot != -1) {
                unqualifiedClassname = extendsAttribute.substring(lastDot + 1);
            } else if (lastDot == -1) {
                unqualifiedClassname = extendsAttribute;
            } else {
                unqualifiedClassname = extendsAttribute.substring(lastDot + 1);
                int withBeanPackage = ((String)extendPackage).lastIndexOf(tablePackage);
                if (withBeanPackage != -1 && !((String)extendPackage).equals(tablePackage)) {
                    extendPackage = ((String)extendPackage).substring(tablePackage.length());
                    logger.debug("key: {}: filtered extendPackage {} from table package: {} ", (Object)key, extendPackage, (Object)tablePackage);
                    extendPackage = this.updatePackage((String)extendPackage, tableBeanPackage);
                } else {
                    extendPackage = tableBeanPackage;
                }
                extendPackage = (String)extendPackage + ".";
                logger.debug("key: {}: extendPackage: {} from table bean package: {} ", (Object)key, extendPackage, (Object)tableBeanPackage);
                String qualifiedClassname = (String)extendPackage + unqualifiedClassname + beanClassNameSuffix;
                logger.info("key: {}: override qualifiedClassname (ignoring beanClassNamePrefix): {}", (Object)key, (Object)qualifiedClassname);
                beanExtends = qualifiedClassname;
            }
            if (beanExtends == null) {
                String beanClassNamePrefix = controllerState.getOption("torque.om.className.beanClassNamePrefix").toString();
                beanExtends = beanClassNamePrefix + unqualifiedClassname + beanClassNameSuffix;
                logger.debug("using extendsAttribute: {} with beanextends {}", (Object)extendsAttribute, beanExtends);
            }
            inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS, beanExtends);
        }
        int lastDot = className.lastIndexOf(".");
        String unqualifiedClassname = lastDot != -1 ? className.substring(lastDot + 1) : className;
        beanClassName = String.valueOf(controllerState.getOption("torque.om.className.beanClassNamePrefix")) + unqualifiedClassname + String.valueOf(controllerState.getOption("torque.om.className.beanClassNameSuffix"));
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_CLASS_NAME, beanClassName);
        String tableBeanPackage = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.BEAN_PACKAGE);
        String beanPackage = this.updatePackage(thisElementPackage, tableBeanPackage, ".bean");
        logger.debug("key: {}: beanPackage {} from {}, {}", (Object)key, (Object)beanPackage, (Object)thisElementPackage, (Object)tableBeanPackage);
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_PACKAGE, (Object)beanPackage);
    }

    private String updatePackage(String thisBeanPackageName, String rootPackage) {
        return this.updatePackage(thisBeanPackageName, rootPackage, "");
    }

    private String updatePackage(String thisBeanPackageName, String rootPackage, String suffix) {
        Object beanPackage = rootPackage;
        if (thisBeanPackageName != null) {
            beanPackage = thisBeanPackageName.startsWith(".") ? (String)beanPackage + thisBeanPackageName : thisBeanPackageName + suffix;
        }
        return beanPackage;
    }
}

