/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.SuffixDAO;
import org.apache.directory.fortress.core.model.Suffix;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuffixP {
    private static final String CLS_NM = SuffixP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    public final void add(Suffix suffix) throws SecurityException {
        this.validate(suffix);
        SuffixDAO sDao = new SuffixDAO();
        sDao.create(suffix);
    }

    public final void delete(Suffix suffix) throws SecurityException {
        this.validate(suffix);
        SuffixDAO sDao = new SuffixDAO();
        sDao.remove(suffix);
    }

    private void validate(Suffix entity) throws SecurityException {
        if (entity.getName().length() > 40) {
            String name = entity.getName();
            String error = "validate name [" + name + "] invalid length [" + entity.getName().length() + "]";
            LOG.warn(error);
            throw new ValidationException(6013, error);
        }
        if (StringUtils.isEmpty((String)entity.getName())) {
            String error = "validate name validation failed, null or empty value";
            LOG.warn(error);
            throw new ValidationException(6012, error);
        }
        if (entity.getDc().length() > 40) {
            String name = entity.getName();
            String error = "validate dc [" + name + "] invalid length [" + entity.getName().length() + "]";
            LOG.warn(error);
            throw new ValidationException(6015, error);
        }
        if (StringUtils.isEmpty((String)entity.getDc())) {
            String error = "validate dc validation failed, null or empty value";
            LOG.warn(error);
            throw new ValidationException(6014, error);
        }
        VUtil.safeText(entity.getDescription(), 180);
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
    }
}

