// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("test_issue_27409") {
    sql """ DROP TABLE IF EXISTS behavior_bitmap_base; """
    sql """
        CREATE TABLE `behavior_bitmap_base` (
            `identity_type_desc` varchar(25) NULL,
            `system_type` varchar(25) NULL,
            `statistic_data` int(11) NULL,
            `one_id` bitmap BITMAP_UNION ,
            INDEX index_identity_type_desc (`identity_type_desc`) USING BITMAP COMMENT 'identity_type_desc',
            INDEX index_system_type (`system_type`) USING BITMAP COMMENT 'system_type',
            INDEX index_statistic_data (`statistic_data`) USING BITMAP COMMENT 'statistic_data'
        ) ENGINE=OLAP
        AGGREGATE KEY(`identity_type_desc`, `system_type`, `statistic_data`)
        DISTRIBUTED BY HASH(`identity_type_desc`, `system_type`, `statistic_data`) BUCKETS 5
        PROPERTIES (
            "replication_num" = "1"
        );
    """
    sql """
        INSERT INTO `behavior_bitmap_base` VALUES
        ('GuestId','renew',1684598400,to_bitmap(0)),
        ('GuestId','renew',1684598400,to_bitmap(0)),
        ('GuestId','renew',1685116800,to_bitmap(0)),
        ('GuestId','renew',1685376000,to_bitmap(0)),
        ('GuestId','renew',1686499200,to_bitmap(0)),
        ('GuestId','renew',1687276800,to_bitmap(0)),
        ('GuestId','renew',1687363200,to_bitmap(0)),
        ('GuestId','renew',1687881600,to_bitmap(0)),
        ('GuestId','renew',1689436800,to_bitmap(0)),
        ('GuestId','renew',1689782400,to_bitmap(0)),
        ('GuestId','renew',1690646400,to_bitmap(0)),
        ('GuestId','renew',1690819200,to_bitmap(0)),
        ('GuestId','renew',1691769600,to_bitmap(0)),
        ('GuestId','renew',1692028800,to_bitmap(0)),
        ('GuestId','renew',1692460800,to_bitmap(0)),
        ('GuestId','renew',1692806400,to_bitmap(0)),
        ('GuestId','renew',1693324800,to_bitmap(0)),
        ('GuestId','renew',1694361600,to_bitmap(0)),
        ('GuestId','renew',1694448000,to_bitmap(0)),
        ('GuestId','renew',1694534400,to_bitmap(0)),
        ('GuestId','renew',1695139200,to_bitmap(0)),
        ('GuestId','renew',1695312000,to_bitmap(0)),
        ('GuestId','renew',1695830400,to_bitmap(0)),
        ('GuestId','renew',1696262400,to_bitmap(0)),
        ('GuestId','renew',1696521600,to_bitmap(0)),
        ('GuestId','renew',1696608000,to_bitmap(0)),
        ('GuestId','renew',1696953600,to_bitmap(0)),
        ('GuestId','renew',1697040000,to_bitmap(0)),
        ('GuestId','renew',1697212800,to_bitmap(0)),
        ('GuestId','renew',1697385600,to_bitmap(0)),
        ('GuestId','renew',1697644800,to_bitmap(0)),
        ('GuestId','renew',1697904000,to_bitmap(0)),
        ('GuestId','renew',1697990400,to_bitmap(0)),
        ('GuestId','renew',1698163200,to_bitmap(0)),
        ('GuestId','renew',1699200000,to_bitmap(0)),
        ('MateId','renew',1684857600,to_bitmap(0)),
        ('MateId','renew',1686844800,to_bitmap(0)),
        ('MateId','renew',1686931200,to_bitmap(0)),
        ('MateId','renew',1687017600,to_bitmap(0)),
        ('MateId','renew',1687449600,to_bitmap(0)),
        ('MateId','renew',1687622400,to_bitmap(0)),
        ('MateId','renew',1688313600,to_bitmap(0)),
        ('MateId','renew',1688572800,to_bitmap(0)),
        ('MateId','renew',1688659200,to_bitmap(0)),
        ('MateId','renew',1689523200,to_bitmap(0)),
        ('MateId','renew',1690041600,to_bitmap(0)),
        ('MateId','renew',1690128000,to_bitmap(0)),
        ('MateId','renew',1690214400,to_bitmap(0)),
        ('MateId','renew',1690387200,to_bitmap(0)),
        ('MateId','renew',1692374400,to_bitmap(0)),
        ('MateId','renew',1692979200,to_bitmap(0)),
        ('MateId','renew',1693238400,to_bitmap(0)),
        ('MateId','renew',1693324800,to_bitmap(0)),
        ('MateId','renew',1693497600,to_bitmap(0)),
        ('MateId','renew',1693670400,to_bitmap(0)),
        ('MateId','renew',1693756800,to_bitmap(0)),
        ('MateId','renew',1693843200,to_bitmap(0)),
        ('MateId','renew',1693929600,to_bitmap(0)),
        ('MateId','renew',1694016000,to_bitmap(0)),
        ('MateId','renew',1694620800,to_bitmap(0)),
        ('MateId','renew',1694707200,to_bitmap(0)),
        ('MateId','renew',1695398400,to_bitmap(0)),
        ('MateId','renew',1696262400,to_bitmap(0)),
        ('MateId','renew',1696435200,to_bitmap(0)),
        ('MateId','renew',1696694400,to_bitmap(0)),
        ('MateId','renew',1696780800,to_bitmap(0)),
        ('MateId','renew',1696867200,to_bitmap(0)),
        ('MateId','renew',1696953600,to_bitmap(0)),
        ('MateId','renew',1697040000,to_bitmap(0)),
        ('MateId','renew',1697644800,to_bitmap(0)),
        ('MateId','renew',1697731200,to_bitmap(0)),
        ('MateId','renew',1698508800,to_bitmap(0)),
        ('MateId','renew',1698681600,to_bitmap(0)),
        ('MateId','renew',1698854400,to_bitmap(0)),
        ('MateId','renew',1699113600,to_bitmap(0)),
        ('MateId','renew',1699632000,to_bitmap(0)),
        ('MateId','scrm',1684771200,to_bitmap(0)),
        ('MateId','scrm',1686153600,to_bitmap(0)),
        ('MateId','scrm',1686326400,to_bitmap(0)),
        ('MateId','scrm',1686412800,to_bitmap(0)),
        ('MateId','scrm',1687276800,to_bitmap(0)),
        ('MateId','scrm',1687795200,to_bitmap(0)),
        ('MateId','scrm',1689523200,to_bitmap(0)),
        ('MateId','scrm',1689782400,to_bitmap(0)),
        ('MateId','scrm',1689955200,to_bitmap(0)),
        ('MateId','scrm',1690560000,to_bitmap(0)),
        ('MateId','scrm',1691078400,to_bitmap(0)),
        ('MateId','scrm',1692460800,to_bitmap(0)),
        ('MateId','scrm',1692892800,to_bitmap(0)),
        ('MateId','scrm',1693065600,to_bitmap(0)),
        ('MateId','scrm',1693324800,to_bitmap(0)),
        ('MateId','scrm',1693584000,to_bitmap(0)),
        ('MateId','scrm',1693670400,to_bitmap(0)),
        ('MateId','scrm',1694102400,to_bitmap(0)),
        ('MateId','scrm',1695139200,to_bitmap(0)),
        ('MateId','scrm',1695916800,to_bitmap(0)),
        ('MateId','scrm',1696521600,to_bitmap(0)),
        ('MateId','scrm',1697558400,to_bitmap(0)),
        ('MateId','scrm',1697904000,to_bitmap(0)),
        ('MateId','scrm',1697990400,to_bitmap(0)),
        ('MateId','scrm',1698163200,to_bitmap(0)),
        ('MateId','scrm',1698422400,to_bitmap(0)),
        ('MateId','scrm',1698508800,to_bitmap(0)),
        ('MateId','scrm',1698681600,to_bitmap(0)),
        ('GuestId','renew',1685808000,to_bitmap(0)),
        ('GuestId','renew',1686067200,to_bitmap(0)),
        ('GuestId','renew',1686153600,to_bitmap(0)),
        ('GuestId','renew',1686240000,to_bitmap(0)),
        ('GuestId','renew',1686326400,to_bitmap(0)),
        ('GuestId','renew',1686758400,to_bitmap(0)),
        ('GuestId','renew',1687017600,to_bitmap(0)),
        ('GuestId','renew',1687708800,to_bitmap(0)),
        ('GuestId','renew',1687795200,to_bitmap(0)),
        ('GuestId','renew',1687968000,to_bitmap(0)),
        ('GuestId','renew',1688227200,to_bitmap(0)),
        ('GuestId','renew',1688400000,to_bitmap(0)),
        ('GuestId','renew',1688832000,to_bitmap(0)),
        ('GuestId','renew',1689177600,to_bitmap(0)),
        ('GuestId','renew',1690214400,to_bitmap(0)),
        ('GuestId','renew',1690473600,to_bitmap(0)),
        ('GuestId','renew',1690560000,to_bitmap(0)),
        ('GuestId','renew',1691078400,to_bitmap(0)),
        ('GuestId','renew',1691510400,to_bitmap(0)),
        ('GuestId','renew',1691683200,to_bitmap(0)),
        ('GuestId','renew',1691856000,to_bitmap(0)),
        ('GuestId','renew',1692115200,to_bitmap(0)),
        ('GuestId','renew',1692374400,to_bitmap(0)),
        ('GuestId','renew',1693065600,to_bitmap(0)),
        ('GuestId','renew',1693756800,to_bitmap(0)),
        ('GuestId','renew',1693843200,to_bitmap(0)),
        ('GuestId','renew',1694275200,to_bitmap(0)),
        ('GuestId','renew',1695225600,to_bitmap(0)),
        ('GuestId','renew',1695916800,to_bitmap(0)),
        ('GuestId','renew',1696435200,to_bitmap(0)),
        ('GuestId','renew',1697299200,to_bitmap(0)),
        ('GuestId','renew',1697472000,to_bitmap(0)),
        ('GuestId','renew',1697817600,to_bitmap(0)),
        ('GuestId','renew',1698681600,to_bitmap(0)),
        ('GuestId','renew',1698854400,to_bitmap(0)),
        ('GuestId','renew',1699113600,to_bitmap(0)),
        ('GuestId','renew',1699545600,to_bitmap(0)),
        ('GuestId','renew',1699804800,to_bitmap(0)),
        ('MateId','renew',1684944000,to_bitmap(0)),
        ('MateId','renew',1685721600,to_bitmap(0)),
        ('MateId','renew',1685980800,to_bitmap(0)),
        ('MateId','renew',1686067200,to_bitmap(0)),
        ('MateId','renew',1687795200,to_bitmap(0)),
        ('MateId','renew',1687881600,to_bitmap(0)),
        ('MateId','renew',1687968000,to_bitmap(0)),
        ('MateId','renew',1688400000,to_bitmap(0)),
        ('MateId','renew',1689091200,to_bitmap(0)),
        ('MateId','renew',1689782400,to_bitmap(0)),
        ('MateId','renew',1689955200,to_bitmap(0)),
        ('MateId','renew',1690646400,to_bitmap(0)),
        ('MateId','renew',1690905600,to_bitmap(0)),
        ('MateId','renew',1691164800,to_bitmap(0)),
        ('MateId','renew',1691683200,to_bitmap(0)),
        ('MateId','renew',1692288000,to_bitmap(0)),
        ('MateId','renew',1693411200,to_bitmap(0)),
        ('MateId','renew',1693584000,to_bitmap(0)),
        ('MateId','renew',1694188800,to_bitmap(0)),
        ('MateId','renew',1694361600,to_bitmap(0)),
        ('MateId','renew',1697212800,to_bitmap(0)),
        ('MateId','renew',1699804800,to_bitmap(0)),
        ('MateId','scrm',1684857600,to_bitmap(0)),
        ('MateId','scrm',1685894400,to_bitmap(0)),
        ('MateId','scrm',1686499200,to_bitmap(0)),
        ('MateId','scrm',1686672000,to_bitmap(0)),
        ('MateId','scrm',1688140800,to_bitmap(0)),
        ('MateId','scrm',1688400000,to_bitmap(0)),
        ('MateId','scrm',1688486400,to_bitmap(0)),
        ('MateId','scrm',1688659200,to_bitmap(0)),
        ('MateId','scrm',1688832000,to_bitmap(0)),
        ('MateId','scrm',1690214400,to_bitmap(0)),
        ('MateId','scrm',1690905600,to_bitmap(0)),
        ('MateId','scrm',1691164800,to_bitmap(0)),
        ('MateId','scrm',1691596800,to_bitmap(0)),
        ('MateId','scrm',1691769600,to_bitmap(0)),
        ('MateId','scrm',1691942400,to_bitmap(0)),
        ('MateId','scrm',1692028800,to_bitmap(0)),
        ('MateId','scrm',1692374400,to_bitmap(0)),
        ('MateId','scrm',1692633600,to_bitmap(0)),
        ('MateId','scrm',1692979200,to_bitmap(0)),
        ('MateId','scrm',1693238400,to_bitmap(0)),
        ('MateId','scrm',1693929600,to_bitmap(0)),
        ('MateId','scrm',1695312000,to_bitmap(0)),
        ('MateId','scrm',1695398400,to_bitmap(0)),
        ('MateId','scrm',1695830400,to_bitmap(0)),
        ('MateId','scrm',1696435200,to_bitmap(0)),
        ('MateId','scrm',1696694400,to_bitmap(0)),
        ('MateId','scrm',1697212800,to_bitmap(0)),
        ('MateId','scrm',1697472000,to_bitmap(0)),
        ('MateId','scrm',1698595200,to_bitmap(0)),
        ('MateId','scrm',1698940800,to_bitmap(0)),
        ('MateId','scrm',1699286400,to_bitmap(0)),
        ('MateId','scrm',1699372800,to_bitmap(0)),
        ('MateId','scrm',1699545600,to_bitmap(0)),
        ('MateId','scrm',1699718400,to_bitmap(0)),
        ('GuestId','renew',1684512000,to_bitmap(0)),
        ('GuestId','renew',1684684800,to_bitmap(0)),
        ('GuestId','renew',1684771200,to_bitmap(0)),
        ('GuestId','renew',1684944000,to_bitmap(0)),
        ('GuestId','renew',1685030400,to_bitmap(0)),
        ('GuestId','renew',1685289600,to_bitmap(0)),
        ('GuestId','renew',1685635200,to_bitmap(0)),
        ('GuestId','renew',1685721600,to_bitmap(0)),
        ('GuestId','renew',1686585600,to_bitmap(0)),
        ('GuestId','renew',1687104000,to_bitmap(0)),
        ('GuestId','renew',1687190400,to_bitmap(0)),
        ('GuestId','renew',1687536000,to_bitmap(0)),
        ('GuestId','renew',1687622400,to_bitmap(0)),
        ('GuestId','renew',1688140800,to_bitmap(0)),
        ('GuestId','renew',1688313600,to_bitmap(0)),
        ('GuestId','renew',1688486400,to_bitmap(0)),
        ('GuestId','renew',1688659200,to_bitmap(0)),
        ('GuestId','renew',1688745600,to_bitmap(0)),
        ('GuestId','renew',1689609600,to_bitmap(0)),
        ('GuestId','renew',1690732800,to_bitmap(0)),
        ('GuestId','renew',1691164800,to_bitmap(0)),
        ('GuestId','renew',1692633600,to_bitmap(0)),
        ('GuestId','renew',1692979200,to_bitmap(0)),
        ('GuestId','renew',1693411200,to_bitmap(0)),
        ('GuestId','renew',1693584000,to_bitmap(0)),
        ('GuestId','renew',1694707200,to_bitmap(0)),
        ('GuestId','renew',1694793600,to_bitmap(0)),
        ('GuestId','renew',1696003200,to_bitmap(0)),
        ('GuestId','renew',1696694400,to_bitmap(0)),
        ('GuestId','renew',1696780800,to_bitmap(0)),
        ('GuestId','renew',1697558400,to_bitmap(0)),
        ('GuestId','renew',1698336000,to_bitmap(0)),
        ('GuestId','renew',1698508800,to_bitmap(0)),
        ('GuestId','renew',1698940800,to_bitmap(0)),
        ('GuestId','renew',1699372800,to_bitmap(0)),
        ('GuestId','renew',1699632000,to_bitmap(0)),
        ('GuestId','renew',1699718400,to_bitmap(0)),
        ('GuestId','renew',1699891200,to_bitmap(0)),
        ('GuestId','renew',1699977600,to_bitmap(0)),
        ('MateId','renew',1684512000,to_bitmap(0)),
        ('MateId','renew',1684598400,to_bitmap(0)),
        ('MateId','renew',1684684800,to_bitmap(0)),
        ('MateId','renew',1684771200,to_bitmap(0)),
        ('MateId','renew',1685203200,to_bitmap(0)),
        ('MateId','renew',1685462400,to_bitmap(0)),
        ('MateId','renew',1685635200,to_bitmap(0)),
        ('MateId','renew',1686326400,to_bitmap(0)),
        ('MateId','renew',1686412800,to_bitmap(0)),
        ('MateId','renew',1687190400,to_bitmap(0)),
        ('MateId','renew',1689350400,to_bitmap(0)),
        ('MateId','renew',1689436800,to_bitmap(0)),
        ('MateId','renew',1689609600,to_bitmap(0)),
        ('MateId','renew',1689696000,to_bitmap(0)),
        ('MateId','renew',1690300800,to_bitmap(0)),
        ('MateId','renew',1690732800,to_bitmap(0)),
        ('MateId','renew',1690992000,to_bitmap(0)),
        ('MateId','renew',1691078400,to_bitmap(0)),
        ('MateId','renew',1691251200,to_bitmap(0)),
        ('MateId','renew',1691769600,to_bitmap(0)),
        ('MateId','renew',1691856000,to_bitmap(0)),
        ('MateId','renew',1692115200,to_bitmap(0)),
        ('MateId','renew',1692547200,to_bitmap(0)),
        ('MateId','renew',1692633600,to_bitmap(0)),
        ('MateId','renew',1693152000,to_bitmap(0)),
        ('MateId','renew',1694275200,to_bitmap(0)),
        ('MateId','renew',1694880000,to_bitmap(0)),
        ('MateId','renew',1695052800,to_bitmap(0)),
        ('MateId','renew',1695225600,to_bitmap(0)),
        ('MateId','renew',1695312000,to_bitmap(0)),
        ('MateId','renew',1695484800,to_bitmap(0)),
        ('MateId','renew',1696003200,to_bitmap(0)),
        ('MateId','renew',1696348800,to_bitmap(0)),
        ('MateId','renew',1696608000,to_bitmap(0)),
        ('MateId','renew',1697126400,to_bitmap(0)),
        ('MateId','renew',1697904000,to_bitmap(0)),
        ('MateId','renew',1697990400,to_bitmap(0)),
        ('MateId','renew',1698076800,to_bitmap(0)),
        ('MateId','renew',1698163200,to_bitmap(0)),
        ('MateId','renew',1698940800,to_bitmap(0)),
        ('MateId','renew',1699891200,to_bitmap(0)),
        ('MateId','scrm',1684598400,to_bitmap(0)),
        ('MateId','scrm',1684684800,to_bitmap(0)),
        ('MateId','scrm',1685289600,to_bitmap(0)),
        ('MateId','scrm',1685462400,to_bitmap(0)),
        ('MateId','scrm',1685721600,to_bitmap(0)),
        ('MateId','scrm',1686240000,to_bitmap(0)),
        ('MateId','scrm',1687017600,to_bitmap(0)),
        ('MateId','scrm',1687104000,to_bitmap(0)),
        ('MateId','scrm',1687881600,to_bitmap(0)),
        ('MateId','scrm',1687968000,to_bitmap(0)),
        ('MateId','scrm',1688054400,to_bitmap(0)),
        ('MateId','scrm',1688313600,to_bitmap(0)),
        ('MateId','scrm',1689091200,to_bitmap(0)),
        ('MateId','scrm',1689350400,to_bitmap(0)),
        ('MateId','scrm',1689868800,to_bitmap(0)),
        ('MateId','scrm',1690732800,to_bitmap(0)),
        ('MateId','scrm',1690819200,to_bitmap(0)),
        ('MateId','scrm',1690992000,to_bitmap(0)),
        ('MateId','scrm',1691337600,to_bitmap(0)),
        ('MateId','scrm',1691424000,to_bitmap(0)),
        ('MateId','scrm',1692115200,to_bitmap(0)),
        ('MateId','scrm',1692720000,to_bitmap(0)),
        ('MateId','scrm',1692806400,to_bitmap(0)),
        ('MateId','scrm',1693497600,to_bitmap(0)),
        ('MateId','scrm',1694620800,to_bitmap(0)),
        ('MateId','scrm',1695225600,to_bitmap(0)),
        ('MateId','scrm',1695484800,to_bitmap(0)),
        ('MateId','scrm',1695657600,to_bitmap(0)),
        ('MateId','scrm',1696089600,to_bitmap(0)),
        ('MateId','scrm',1696176000,to_bitmap(0)),
        ('MateId','scrm',1696262400,to_bitmap(0)),
        ('MateId','scrm',1696608000,to_bitmap(0)),
        ('MateId','scrm',1696780800,to_bitmap(0)),
        ('MateId','scrm',1696867200,to_bitmap(0)),
        ('MateId','scrm',1697385600,to_bitmap(0)),
        ('MateId','scrm',1697644800,to_bitmap(0)),
        ('MateId','scrm',1698249600,to_bitmap(0)),
        ('MateId','scrm',1699113600,to_bitmap(0)),
        ('MateId','scrm',1699804800,to_bitmap(0)),
        ('MateId','scrm',1699891200,to_bitmap(0)),
        ('MateId','scrm',1699977600,to_bitmap(0)),
        ('GuestId','renew',1684425600,to_bitmap(0)),
        ('GuestId','renew',1685462400,to_bitmap(0)),
        ('GuestId','renew',1685980800,to_bitmap(0)),
        ('GuestId','renew',1686412800,to_bitmap(0)),
        ('GuestId','renew',1686844800,to_bitmap(0)),
        ('GuestId','renew',1686931200,to_bitmap(0)),
        ('GuestId','renew',1687449600,to_bitmap(0)),
        ('GuestId','renew',1688572800,to_bitmap(0)),
        ('GuestId','renew',1688918400,to_bitmap(0)),
        ('GuestId','renew',1689350400,to_bitmap(0)),
        ('GuestId','renew',1689696000,to_bitmap(0)),
        ('GuestId','renew',1689868800,to_bitmap(0)),
        ('GuestId','renew',1689955200,to_bitmap(0)),
        ('GuestId','renew',1690387200,to_bitmap(0)),
        ('GuestId','renew',1690992000,to_bitmap(0)),
        ('GuestId','renew',1691251200,to_bitmap(0)),
        ('GuestId','renew',1691337600,to_bitmap(0)),
        ('GuestId','renew',1691424000,to_bitmap(0)),
        ('GuestId','renew',1692288000,to_bitmap(0)),
        ('GuestId','renew',1692547200,to_bitmap(0)),
        ('GuestId','renew',1692720000,to_bitmap(0)),
        ('GuestId','renew',1692892800,to_bitmap(0)),
        ('GuestId','renew',1693670400,to_bitmap(0)),
        ('GuestId','renew',1694016000,to_bitmap(0)),
        ('GuestId','renew',1694102400,to_bitmap(0)),
        ('GuestId','renew',1694188800,to_bitmap(0)),
        ('GuestId','renew',1694620800,to_bitmap(0)),
        ('GuestId','renew',1694880000,to_bitmap(0)),
        ('GuestId','renew',1694966400,to_bitmap(0)),
        ('GuestId','renew',1695052800,to_bitmap(0)),
        ('GuestId','renew',1695398400,to_bitmap(0)),
        ('GuestId','renew',1695484800,to_bitmap(0)),
        ('GuestId','renew',1695571200,to_bitmap(0)),
        ('GuestId','renew',1695657600,to_bitmap(0)),
        ('GuestId','renew',1695744000,to_bitmap(0)),
        ('GuestId','renew',1696089600,to_bitmap(0)),
        ('GuestId','renew',1696348800,to_bitmap(0)),
        ('GuestId','renew',1696867200,to_bitmap(0)),
        ('GuestId','renew',1698422400,to_bitmap(0)),
        ('GuestId','renew',1698595200,to_bitmap(0)),
        ('GuestId','renew',1698768000,to_bitmap(0)),
        ('MateId','renew',1685030400,to_bitmap(0)),
        ('MateId','renew',1685116800,to_bitmap(0)),
        ('MateId','renew',1685289600,to_bitmap(0)),
        ('MateId','renew',1685376000,to_bitmap(0)),
        ('MateId','renew',1685808000,to_bitmap(0)),
        ('MateId','renew',1686153600,to_bitmap(0)),
        ('MateId','renew',1686240000,to_bitmap(0)),
        ('MateId','renew',1686499200,to_bitmap(0)),
        ('MateId','renew',1686585600,to_bitmap(0)),
        ('MateId','renew',1686672000,to_bitmap(0)),
        ('MateId','renew',1687104000,to_bitmap(0)),
        ('MateId','renew',1687536000,to_bitmap(0)),
        ('MateId','renew',1688054400,to_bitmap(0)),
        ('MateId','renew',1688140800,to_bitmap(0)),
        ('MateId','renew',1688227200,to_bitmap(0)),
        ('MateId','renew',1688745600,to_bitmap(0)),
        ('MateId','renew',1688918400,to_bitmap(0)),
        ('MateId','renew',1689004800,to_bitmap(0)),
        ('MateId','renew',1689264000,to_bitmap(0)),
        ('MateId','renew',1690560000,to_bitmap(0)),
        ('MateId','renew',1691337600,to_bitmap(0)),
        ('MateId','renew',1691510400,to_bitmap(0)),
        ('MateId','renew',1691596800,to_bitmap(0)),
        ('MateId','renew',1692028800,to_bitmap(0)),
        ('MateId','renew',1692460800,to_bitmap(0)),
        ('MateId','renew',1692720000,to_bitmap(0)),
        ('MateId','renew',1692806400,to_bitmap(0)),
        ('MateId','renew',1694102400,to_bitmap(0)),
        ('MateId','renew',1694534400,to_bitmap(0)),
        ('MateId','renew',1695571200,to_bitmap(0)),
        ('MateId','renew',1695657600,to_bitmap(0)),
        ('MateId','renew',1695744000,to_bitmap(0)),
        ('MateId','renew',1695916800,to_bitmap(0)),
        ('MateId','renew',1696089600,to_bitmap(0)),
        ('MateId','renew',1697299200,to_bitmap(0)),
        ('MateId','renew',1697472000,to_bitmap(0)),
        ('MateId','renew',1697558400,to_bitmap(0)),
        ('MateId','renew',1697817600,to_bitmap(0)),
        ('MateId','renew',1698249600,to_bitmap(0)),
        ('MateId','renew',1698595200,to_bitmap(0)),
        ('MateId','renew',1698768000,to_bitmap(0)),
        ('MateId','renew',1699286400,to_bitmap(0)),
        ('MateId','renew',1699372800,to_bitmap(0)),
        ('MateId','renew',1699459200,to_bitmap(0)),
        ('MateId','renew',1699545600,to_bitmap(0)),
        ('MateId','renew',1699718400,to_bitmap(0)),
        ('MateId','renew',1699977600,to_bitmap(0)),
        ('MateId','scrm',1684425600,to_bitmap(0)),
        ('MateId','scrm',1685030400,to_bitmap(0)),
        ('MateId','scrm',1685116800,to_bitmap(0)),
        ('MateId','scrm',1685203200,to_bitmap(0)),
        ('MateId','scrm',1685548800,to_bitmap(0)),
        ('MateId','scrm',1685635200,to_bitmap(0)),
        ('MateId','scrm',1685808000,to_bitmap(0)),
        ('MateId','scrm',1687190400,to_bitmap(0)),
        ('MateId','scrm',1687363200,to_bitmap(0)),
        ('MateId','scrm',1687622400,to_bitmap(0)),
        ('MateId','scrm',1687708800,to_bitmap(0)),
        ('MateId','scrm',1688227200,to_bitmap(0)),
        ('MateId','scrm',1689177600,to_bitmap(0)),
        ('MateId','scrm',1689264000,to_bitmap(0)),
        ('MateId','scrm',1689696000,to_bitmap(0)),
        ('MateId','scrm',1690041600,to_bitmap(0)),
        ('MateId','scrm',1690128000,to_bitmap(0)),
        ('MateId','scrm',1690646400,to_bitmap(0)),
        ('MateId','scrm',1691510400,to_bitmap(0)),
        ('MateId','scrm',1691683200,to_bitmap(0)),
        ('MateId','scrm',1691856000,to_bitmap(0)),
        ('MateId','scrm',1692201600,to_bitmap(0)),
        ('MateId','scrm',1692288000,to_bitmap(0)),
        ('MateId','scrm',1693411200,to_bitmap(0)),
        ('MateId','scrm',1693843200,to_bitmap(0)),
        ('MateId','scrm',1694188800,to_bitmap(0)),
        ('MateId','scrm',1694361600,to_bitmap(0)),
        ('MateId','scrm',1694534400,to_bitmap(0)),
        ('MateId','scrm',1694707200,to_bitmap(0)),
        ('MateId','scrm',1695052800,to_bitmap(0)),
        ('MateId','scrm',1695744000,to_bitmap(0)),
        ('MateId','scrm',1696953600,to_bitmap(0)),
        ('MateId','scrm',1697299200,to_bitmap(0)),
        ('MateId','scrm',1697817600,to_bitmap(0)),
        ('MateId','scrm',1698768000,to_bitmap(0)),
        ('MateId','scrm',1698854400,to_bitmap(0)),
        ('MateId','scrm',1699027200,to_bitmap(0)),
        ('GuestId','renew',1684857600,to_bitmap(0)),
        ('GuestId','renew',1685203200,to_bitmap(0)),
        ('GuestId','renew',1685548800,to_bitmap(0)),
        ('GuestId','renew',1685894400,to_bitmap(0)),
        ('GuestId','renew',1686672000,to_bitmap(0)),
        ('GuestId','renew',1688054400,to_bitmap(0)),
        ('GuestId','renew',1689004800,to_bitmap(0)),
        ('GuestId','renew',1689091200,to_bitmap(0)),
        ('GuestId','renew',1689264000,to_bitmap(0)),
        ('GuestId','renew',1689523200,to_bitmap(0)),
        ('GuestId','renew',1690041600,to_bitmap(0)),
        ('GuestId','renew',1690128000,to_bitmap(0)),
        ('GuestId','renew',1690300800,to_bitmap(0)),
        ('GuestId','renew',1690905600,to_bitmap(0)),
        ('GuestId','renew',1691596800,to_bitmap(0)),
        ('GuestId','renew',1691942400,to_bitmap(0)),
        ('GuestId','renew',1692201600,to_bitmap(0)),
        ('GuestId','renew',1693152000,to_bitmap(0)),
        ('GuestId','renew',1693238400,to_bitmap(0)),
        ('GuestId','renew',1693497600,to_bitmap(0)),
        ('GuestId','renew',1693929600,to_bitmap(0)),
        ('GuestId','renew',1696176000,to_bitmap(0)),
        ('GuestId','renew',1697126400,to_bitmap(0)),
        ('GuestId','renew',1697731200,to_bitmap(0)),
        ('GuestId','renew',1698076800,to_bitmap(0)),
        ('GuestId','renew',1698249600,to_bitmap(0)),
        ('GuestId','renew',1699027200,to_bitmap(0)),
        ('GuestId','renew',1699286400,to_bitmap(0)),
        ('GuestId','renew',1699459200,to_bitmap(0)),
        ('MateId','renew',1684425600,to_bitmap(0)),
        ('MateId','renew',1685548800,to_bitmap(0)),
        ('MateId','renew',1685894400,to_bitmap(0)),
        ('MateId','renew',1686758400,to_bitmap(0)),
        ('MateId','renew',1687276800,to_bitmap(0)),
        ('MateId','renew',1687363200,to_bitmap(0)),
        ('MateId','renew',1687708800,to_bitmap(0)),
        ('MateId','renew',1688486400,to_bitmap(0)),
        ('MateId','renew',1688832000,to_bitmap(0)),
        ('MateId','renew',1689177600,to_bitmap(0)),
        ('MateId','renew',1689868800,to_bitmap(0)),
        ('MateId','renew',1690473600,to_bitmap(0)),
        ('MateId','renew',1690819200,to_bitmap(0)),
        ('MateId','renew',1691424000,to_bitmap(0)),
        ('MateId','renew',1691942400,to_bitmap(0)),
        ('MateId','renew',1692201600,to_bitmap(0)),
        ('MateId','renew',1692892800,to_bitmap(0)),
        ('MateId','renew',1693065600,to_bitmap(0)),
        ('MateId','renew',1694448000,to_bitmap(0)),
        ('MateId','renew',1694793600,to_bitmap(0)),
        ('MateId','renew',1694966400,to_bitmap(0)),
        ('MateId','renew',1695139200,to_bitmap(0)),
        ('MateId','renew',1695830400,to_bitmap(0)),
        ('MateId','renew',1696176000,to_bitmap(0)),
        ('MateId','renew',1696521600,to_bitmap(0)),
        ('MateId','renew',1697385600,to_bitmap(0)),
        ('MateId','renew',1698336000,to_bitmap(0)),
        ('MateId','renew',1698422400,to_bitmap(0)),
        ('MateId','renew',1699027200,to_bitmap(0)),
        ('MateId','renew',1699200000,to_bitmap(0)),
        ('MateId','scrm',1684512000,to_bitmap(0)),
        ('MateId','scrm',1684944000,to_bitmap(0)),
        ('MateId','scrm',1685376000,to_bitmap(0)),
        ('MateId','scrm',1685980800,to_bitmap(0)),
        ('MateId','scrm',1686067200,to_bitmap(0)),
        ('MateId','scrm',1686585600,to_bitmap(0)),
        ('MateId','scrm',1686758400,to_bitmap(0)),
        ('MateId','scrm',1686844800,to_bitmap(0)),
        ('MateId','scrm',1686931200,to_bitmap(0)),
        ('MateId','scrm',1687449600,to_bitmap(0)),
        ('MateId','scrm',1687536000,to_bitmap(0)),
        ('MateId','scrm',1688572800,to_bitmap(0)),
        ('MateId','scrm',1688745600,to_bitmap(0)),
        ('MateId','scrm',1688918400,to_bitmap(0)),
        ('MateId','scrm',1689004800,to_bitmap(0)),
        ('MateId','scrm',1689436800,to_bitmap(0)),
        ('MateId','scrm',1689609600,to_bitmap(0)),
        ('MateId','scrm',1690300800,to_bitmap(0)),
        ('MateId','scrm',1690387200,to_bitmap(0)),
        ('MateId','scrm',1690473600,to_bitmap(0)),
        ('MateId','scrm',1691251200,to_bitmap(0)),
        ('MateId','scrm',1692547200,to_bitmap(0)),
        ('MateId','scrm',1693152000,to_bitmap(0)),
        ('MateId','scrm',1693756800,to_bitmap(0)),
        ('MateId','scrm',1694016000,to_bitmap(0)),
        ('MateId','scrm',1694275200,to_bitmap(0)),
        ('MateId','scrm',1694448000,to_bitmap(0)),
        ('MateId','scrm',1694793600,to_bitmap(0)),
        ('MateId','scrm',1694880000,to_bitmap(0)),
        ('MateId','scrm',1694966400,to_bitmap(0)),
        ('MateId','scrm',1695571200,to_bitmap(0)),
        ('MateId','scrm',1696003200,to_bitmap(0)),
        ('MateId','scrm',1696348800,to_bitmap(0)),
        ('MateId','scrm',1697040000,to_bitmap(0)),
        ('MateId','scrm',1697126400,to_bitmap(0)),
        ('MateId','scrm',1697731200,to_bitmap(0)),
        ('MateId','scrm',1698076800,to_bitmap(0)),
        ('MateId','scrm',1698336000,to_bitmap(0)),
        ('MateId','scrm',1699200000,to_bitmap(0)),
        ('MateId','scrm',1699459200,to_bitmap(0)),
        ('MateId','scrm',1699632000,to_bitmap(0));
    """

    sql """
        INSERT INTO `behavior_bitmap_base` VALUES
        ('member_id','m_oneid',1,bitmap_from_string("1,5,6,8,9,11,12,13,14,18,19,22,24,25,29,31,34,36,40,41,45,46,47,50,56,57,58,59,64,65,66,67,68,70,71,72")),
        ('customer_id','c_oneid',1,bitmap_from_string("2,3,4,7,10,15,16,17,20,21,23,26,27,28,30,32,33,35,37,38,39,42,43,44,48,49,51,52,53,54,55,60,61,62,63,69"));
    """

    for (int i = 1; i <= 30; i++) {
        sql """
            select
                a.identity_type_desc,
                a.system_type,
                a.statistic_data,
                bitmap_xor(a.one_id, b.one_id) as one_id
            from
            (
                select
                    identity_type_desc,
                    system_type,
                    statistic_data,
                    one_id
                from
                    behavior_bitmap_base
                where
                    identity_type_desc = 'MateId'
            ) a join 
            (
                select
                    one_id
                from
                    behavior_bitmap_base
                where
                    system_type = 'm_oneid'
            ) b
            union all
            select
                a.identity_type_desc,
                a.system_type,
                a.statistic_data,
                bitmap_xor(a.one_id, b.one_id) as one_id
            from
            (
                select
                    identity_type_desc,
                    system_type,
                    statistic_data,
                    one_id
                from
                    behavior_bitmap_base
                where identity_type_desc = 'GuestId'
            ) a join
            (
                select
                    one_id
                from
                    behavior_bitmap_base
                where system_type = 'c_oneid'
            ) b
        """
    }
}
