/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;

public class SegmentsToUpdateFilter {
    private final Interval interval;
    private final Set<String> segmentIds;
    private final List<String> versions;
    public static final String INVALID_PAYLOAD_ERROR_MESSAGE = "Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.";

    @JsonCreator
    public SegmentsToUpdateFilter(@JsonProperty(value="interval") @Nullable Interval interval, @JsonProperty(value="segmentIds") @Nullable Set<String> segmentIds, @JsonProperty(value="versions") @Nullable List<String> versions) {
        this.interval = interval;
        this.segmentIds = segmentIds;
        this.versions = versions;
    }

    @Nullable
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public Set<String> getSegmentIds() {
        return this.segmentIds;
    }

    @Nullable
    @JsonProperty
    public List<String> getVersions() {
        return this.versions;
    }

    public boolean isValid() {
        boolean hasSegmentIds;
        boolean bl = hasSegmentIds = !CollectionUtils.isNullOrEmpty(this.segmentIds);
        if (this.interval == null) {
            return hasSegmentIds && CollectionUtils.isNullOrEmpty(this.versions);
        }
        return !hasSegmentIds;
    }
}

