/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.field.ComplexFieldReader;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class FrameReaderUtils {
    public static ByteBuffer readByteBuffer(Memory memory, long dataStart, int dataLength) {
        if (memory.hasByteBuffer()) {
            ByteBuffer byteBuffer = memory.getByteBuffer().duplicate();
            byteBuffer.limit(Ints.checkedCast((long)memory.getRegionOffset(dataStart + (long)dataLength)));
            byteBuffer.position(Ints.checkedCast((long)memory.getRegionOffset(dataStart)));
            return byteBuffer;
        }
        byte[] stringData = new byte[dataLength];
        memory.getByteArray(dataStart, stringData, 0, stringData.length);
        return ByteBuffer.wrap(stringData);
    }

    @Nullable
    public static Supplier<MemoryRange<Memory>> makeRowMemorySupplier(ColumnSelectorFactory columnSelectorFactory, final FrameType expectedFrameType, final RowSignature expectedSignature) {
        if (FrameReaderUtils.mayBeAbleToSelectRowMemory(columnSelectorFactory)) {
            final ColumnValueSelector frameTypeSelector = columnSelectorFactory.makeColumnValueSelector("___druid_frame_type");
            final ColumnValueSelector signatureSelector = columnSelectorFactory.makeColumnValueSelector("___druid_frame_row_signature");
            final ColumnValueSelector memorySelector = columnSelectorFactory.makeColumnValueSelector("___druid_frame_row_mem");
            return new Supplier<MemoryRange<Memory>>(){
                private RowSignature lastSignature = null;
                private boolean lastSignatureOk = false;

                @Override
                public MemoryRange<Memory> get() {
                    FrameType selectedFrameType = (FrameType)((Object)frameTypeSelector.getObject());
                    if (selectedFrameType != expectedFrameType) {
                        return null;
                    }
                    RowSignature selectedSignature = (RowSignature)signatureSelector.getObject();
                    if (selectedSignature != this.lastSignature) {
                        this.lastSignature = selectedSignature;
                        this.lastSignatureOk = expectedSignature.equals(selectedSignature);
                    }
                    if (this.lastSignatureOk) {
                        return (MemoryRange)memorySelector.getObject();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public static int compareMemoryUnsigned(Memory memory1, long position1, int length1, Memory memory2, long position2, int length2) {
        int commonLength = Math.min(length1, length2);
        for (int i = 0; i < commonLength; i += 8) {
            long r2;
            int remaining = commonLength - i;
            long r1 = FrameReaderUtils.readComparableLong(memory1, position1 + (long)i, remaining);
            int cmp = Long.compare(r1, r2 = FrameReaderUtils.readComparableLong(memory2, position2 + (long)i, remaining));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(length1, length2);
    }

    public static long readComparableLong(Memory memory, long position, int length) {
        long retVal = 0L;
        switch (length) {
            case 7: {
                retVal |= ((long)memory.getByte(position + 6L) & 0xFFL) << 8;
            }
            case 6: {
                retVal |= ((long)memory.getByte(position + 5L) & 0xFFL) << 16;
            }
            case 5: {
                retVal |= ((long)memory.getByte(position + 4L) & 0xFFL) << 24;
            }
            case 4: {
                retVal |= ((long)memory.getByte(position + 3L) & 0xFFL) << 32;
            }
            case 3: {
                retVal |= ((long)memory.getByte(position + 2L) & 0xFFL) << 40;
            }
            case 2: {
                retVal |= ((long)memory.getByte(position + 1L) & 0xFFL) << 48;
            }
            case 1: {
                retVal |= ((long)memory.getByte(position) & 0xFFL) << 56;
                break;
            }
            default: {
                retVal = Long.reverseBytes(memory.getLong(position));
            }
        }
        return retVal + Long.MIN_VALUE;
    }

    public static int compareMemoryToByteArrayUnsigned(Memory memory, long position1, long length1, byte[] array, int position2, int length2) {
        int commonLength = (int)Math.min(length1, (long)length2);
        for (int i = 0; i < commonLength; ++i) {
            byte byte2;
            byte byte1 = memory.getByte(position1 + (long)i);
            int cmp = (byte1 & 0xFF) - ((byte2 = array[position2 + i]) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Long.compare(length1, length2);
    }

    public static int compareByteArraysUnsigned(byte[] array1, int position1, int length1, byte[] array2, int position2, int length2) {
        int commonLength = Math.min(length1, length2);
        for (int i = 0; i < commonLength; ++i) {
            byte byte1 = array1[position1 + i];
            byte byte2 = array2[position2 + i];
            int cmp = (byte1 & 0xFF) - (byte2 & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(length1, length2);
    }

    public static int compareComplexTypes(byte[] array1, int position1, byte[] array2, int position2, ColumnType columnType, ComplexMetricSerde complexMetricSerde) {
        return columnType.getNullableStrategy().compare(ComplexFieldReader.readFieldFromByteArray(complexMetricSerde, array1, position1), ComplexFieldReader.readFieldFromByteArray(complexMetricSerde, array2, position2));
    }

    public static int compareComplexTypes(Memory memory, long position1, byte[] array, int position2, ColumnType columnType, ComplexMetricSerde complexMetricSerde) {
        return columnType.getNullableStrategy().compare(ComplexFieldReader.readFieldFromMemory(complexMetricSerde, memory, position1), ComplexFieldReader.readFieldFromByteArray(complexMetricSerde, array, position2));
    }

    public static int compareComplexTypes(Memory memory1, long position1, Memory memory2, long position2, ColumnType columnType, ComplexMetricSerde complexMetricSerde) {
        return columnType.getNullableStrategy().compare(ComplexFieldReader.readFieldFromMemory(complexMetricSerde, memory1, position1), ComplexFieldReader.readFieldFromMemory(complexMetricSerde, memory2, position2));
    }

    private static boolean mayBeAbleToSelectRowMemory(ColumnSelectorFactory columnSelectorFactory) {
        List<String> requiredColumns = List.of("___druid_frame_type", "___druid_frame_row_signature", "___druid_frame_row_mem");
        for (String columnName : requiredColumns) {
            if (columnSelectorFactory.getColumnCapabilities(columnName) != null) continue;
            return false;
        }
        return true;
    }
}

