/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.primitives.Ints;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class ComplexFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    ComplexFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        return new ColumnAccessorBasedColumn(this.makeComplexFrameColumn(frame));
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        ComplexFrameColumn frameCol = this.makeComplexFrameColumn(frame);
        return new ColumnPlus(frameCol, new ColumnCapabilitiesImpl().setType(frameCol.getType()).setHasMultipleValues(false), frame.numRows());
    }

    @Nonnull
    private ComplexFrameColumn makeComplexFrameColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory, frame.numRows());
        int typeNameLength = memory.getInt(1L);
        byte[] typeNameBytes = new byte[typeNameLength];
        memory.getByteArray(5L, typeNameBytes, 0, typeNameLength);
        String typeName = StringUtils.fromUtf8(typeNameBytes);
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
        if (serde == null) {
            throw new ISE("Cannot read column with complexTypeName[%s]", typeName);
        }
        long startOfOffsetSection = 5 + typeNameLength;
        long startOfDataSection = startOfOffsetSection + (long)frame.numRows() * 4L;
        return new ComplexFrameColumn(frame, serde, memory, startOfOffsetSection, startOfDataSection);
    }

    private void validate(Memory region, int numRows) {
        if (region.getCapacity() < 5L) {
            throw new ISE("Column is not big enough for a header", new Object[0]);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 5) {
            throw new ISE("Column does not have the correct type code", new Object[0]);
        }
        int typeNameLength = region.getInt(1L);
        if (region.getCapacity() < (long)(5 + typeNameLength) + (long)numRows * 4L) {
            throw new ISE("Column is missing offset section", new Object[0]);
        }
    }

    private static class ComplexFrameColumn
    extends ObjectColumnAccessorBase
    implements ComplexColumn {
        private final Frame frame;
        private final ComplexMetricSerde serde;
        private final Class<?> clazz;
        private final Memory memory;
        private final long startOfOffsetSection;
        private final long startOfDataSection;

        private ComplexFrameColumn(Frame frame, ComplexMetricSerde serde, Memory memory, long startOfOffsetSection, long startOfDataSection) {
            this.frame = frame;
            this.serde = serde;
            this.clazz = serde.getObjectStrategy().getClazz();
            this.memory = memory;
            this.startOfOffsetSection = startOfOffsetSection;
            this.startOfDataSection = startOfDataSection;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new ObjectColumnSelector<Object>(){

                @Override
                @Nullable
                public Object getObject() {
                    return this.getObjectForPhysicalRow(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public Class<?> classOfObject() {
                    return clazz;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public Class<?> getClazz() {
            return this.serde.getClass();
        }

        @Override
        public String getTypeName() {
            return this.serde.getTypeName();
        }

        @Override
        @Nullable
        public Object getRowValue(int rowNum) {
            if (rowNum < 0 || rowNum >= this.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", rowNum);
            }
            return this.getObjectForPhysicalRow(this.frame.physicalRow(rowNum));
        }

        @Override
        public int getLength() {
            return (int)this.frame.numBytes();
        }

        @Override
        public void close() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.ofComplex(this.serde.getTypeName());
        }

        @Override
        public int numRows() {
            return this.getLength();
        }

        @Override
        protected Object getVal(int rowNum) {
            return this.getRowValue(rowNum);
        }

        @Override
        protected Comparator<Object> getComparator() {
            return this.serde.getTypeStrategy();
        }

        @Nullable
        private Object getObjectForPhysicalRow(int physicalRow) {
            long endOffset = this.startOfDataSection + (long)this.memory.getInt(this.startOfOffsetSection + 4L * (long)physicalRow);
            long startOffset = physicalRow == 0 ? this.startOfDataSection : this.startOfDataSection + (long)this.memory.getInt(this.startOfOffsetSection + 4L * (long)(physicalRow - 1));
            if (this.memory.getByte(startOffset) == 1) {
                return null;
            }
            int payloadLength = Ints.checkedCast((long)(endOffset - startOffset - 1L));
            byte[] complexBytes = new byte[payloadLength];
            this.memory.getByteArray(startOffset + 1L, complexBytes, 0, payloadLength);
            return this.serde.fromBytes(complexBytes, 0, complexBytes.length);
        }
    }
}

