/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongBivariateObjectsFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.SimpleVectorMathBivariateLongProcessorFactory;
import org.apache.druid.math.expr.vector.functional.ComparatorFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateDoubleLongFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateDoublesFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateLongDoubleFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateLongsFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateObjectsFunction;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.Types;

public class SimpleVectorComparisonProcessorFactory
extends SimpleVectorMathBivariateLongProcessorFactory {
    private final ComparatorFunction comparatorFunction;

    public SimpleVectorComparisonProcessorFactory(ComparatorFunction comparatorFunction, LongBivariateLongsFunction longsFunction, LongBivariateLongDoubleFunction longDoubleFunction, LongBivariateDoubleLongFunction doubleLongFunction, LongBivariateDoublesFunction doublesFunction) {
        super(longsFunction, longDoubleFunction, doubleLongFunction, doublesFunction);
        this.comparatorFunction = comparatorFunction;
    }

    @Override
    public <T> ExprVectorProcessor<T> asProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        ExpressionType leftType = left.getOutputType(inspector);
        ExpressionType rightType = right.getOutputType(inspector);
        if (Types.isNumeric(leftType) || Types.isNumeric(rightType)) {
            return super.asProcessor(inspector, left, right);
        }
        ExprVectorProcessor<long[]> processor = null;
        ExpressionType commonType = ExpressionTypeConversion.leastRestrictiveType(leftType, rightType);
        if (commonType != null) {
            processor = this.objectsProcessor(inspector, left, right, commonType);
        }
        if (processor != null) {
            return processor;
        }
        return super.asProcessor(inspector, left, right);
    }

    private ExprVectorProcessor<long[]> objectsProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right, ExpressionType inputType) {
        return new LongBivariateObjectsFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), inputType, new ObjectsComparatorFunction(inputType.getNullableStrategy(), this.comparatorFunction));
    }

    public static final class ObjectsComparatorFunction
    implements LongBivariateObjectsFunction {
        private final NullableTypeStrategy<Object> nullableTypeStrategy;
        private final ComparatorFunction comparatorFunction;

        public ObjectsComparatorFunction(NullableTypeStrategy<Object> nullableTypeStrategy, ComparatorFunction comparatorFunction) {
            this.nullableTypeStrategy = nullableTypeStrategy;
            this.comparatorFunction = comparatorFunction;
        }

        @Override
        @Nullable
        public Long process(@Nullable Object left, @Nullable Object right) {
            return Evals.asLong(this.comparatorFunction.compare(this.nullableTypeStrategy.compare(left, right)));
        }
    }
}

