/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.CastedLiteralOperandTypeCheckers;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.NativelySupportsDistinct;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class StringSqlAggregator
implements SqlAggregator {
    private final SqlAggFunction function;
    public static final StringSqlAggregator STRING_AGG = new StringSqlAggregator(new StringAggFunction("STRING_AGG"));
    public static final StringSqlAggregator LISTAGG = new StringSqlAggregator(new StringAggFunction("LISTAGG"));

    public StringSqlAggregator(SqlAggFunction function) {
        this.function = function;
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        List arguments = aggregateCall.getArgList().stream().map(i -> inputAccessor.getField((int)i)).map(rexNode -> Expressions.toDruidExpression(plannerContext, inputAccessor.getInputRowSignature(), rexNode)).collect(Collectors.toList());
        if (arguments.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        RexNode separatorNode = inputAccessor.getField((Integer)aggregateCall.getArgList().get(1));
        if (!separatorNode.isA(SqlKind.LITERAL)) {
            return null;
        }
        String separator = RexLiteral.stringValue((RexNode)separatorNode);
        if (separator == null) {
            return null;
        }
        Integer maxSizeBytes = null;
        if (arguments.size() > 2) {
            RexNode maxBytes = inputAccessor.getField((Integer)aggregateCall.getArgList().get(2));
            if (!maxBytes.isA(SqlKind.LITERAL)) {
                return null;
            }
            maxSizeBytes = ((Number)((Object)RexLiteral.value((RexNode)maxBytes))).intValue();
        }
        DruidExpression arg = (DruidExpression)arguments.get(0);
        ExprMacroTable macroTable = plannerContext.getPlannerToolbox().exprMacroTable();
        String initialvalue = "[]";
        ColumnType elementType = ColumnType.STRING;
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, elementType);
        String finalizer = StringUtils.format((String)"if(array_length(o) == 0, null, array_to_string(o, '%s'))", (Object[])new Object[]{separator});
        NotDimFilter dimFilter = new NotDimFilter((DimFilter)(plannerContext.isUseBoundsAndSelectors() ? new SelectorDimFilter(fieldName, null, null) : NullFilter.forColumn((String)fieldName)));
        if (aggregateCall.isDistinct()) {
            return Aggregation.create((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, "[]", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_set_add(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_set_add_all(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, finalizer, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable), (DimFilter)dimFilter));
        }
        return Aggregation.create((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, "[]", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_append(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_concat(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, finalizer, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable), (DimFilter)dimFilter));
    }

    @NativelySupportsDistinct
    private static class StringAggFunction
    extends SqlAggFunction {
        private static final StringAggReturnTypeInference RETURN_TYPE_INFERENCE = new StringAggReturnTypeInference();

        StringAggFunction(String name) {
            super(name, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)RETURN_TYPE_INFERENCE, InferTypes.ANY_NULLABLE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)StringUtils.format((String)"'%s(expr, separator)'", (Object[])new Object[]{name}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)StringUtils.format((String)"'%s(expr, separator, maxSizeBytes)'", (Object[])new Object[]{name}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.STRING, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC})})}), SqlFunctionCategory.STRING, false, false, Optionality.IGNORED);
        }
    }

    static class StringAggReturnTypeInference
    implements SqlReturnTypeInference {
        StringAggReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            RelDataType type = sqlOperatorBinding.getOperandType(0);
            if (type instanceof RowSignatures.ComplexSqlType) {
                String columnName = "";
                if (sqlOperatorBinding instanceof SqlCallBinding) {
                    columnName = ((SqlCallBinding)sqlOperatorBinding).getCall().operand(0).toString();
                }
                throw SimpleSqlAggregator.badTypeException(columnName, "STRING_AGG", ((RowSignatures.ComplexSqlType)type).getColumnType());
            }
            return Calcites.createSqlTypeWithNullability(sqlOperatorBinding.getTypeFactory(), SqlTypeName.VARCHAR, true);
        }
    }
}

