/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rvesse.airline.annotations.Command;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.testing.metrics.EventCollectorResource;
import org.eclipse.jetty.ee8.servlet.DefaultServlet;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;

@Command(name="eventCollector", description="Custom Druid node role used to collect metrics over HTTP")
public class CliEventCollector
extends ServerRunnable {
    private static final Logger LOG = new Logger(CliEventCollector.class);
    public static final String SERVICE_NAME = "eventCollector";
    public static final int PORT = 9301;
    public static final int TLS_PORT = 9501;
    public static final NodeRole NODE_ROLE = new NodeRole("eventCollector");

    public CliEventCollector() {
        super(LOG);
    }

    protected Set<NodeRole> getNodeRoles(Properties properties) {
        return Set.of(NODE_ROLE);
    }

    protected List<? extends Module> getModules() {
        return List.of(binder -> {
            LOG.info("Starting Test Service [eventCollector]. This is a test only Druid service which must never be used in production.", new Object[0]);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to(SERVICE_NAME);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9301);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(9501);
            binder.bind(JettyServerInitializer.class).to(CustomJettyServiceInitializer.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, Server.class);
            Jerseys.addResource((Binder)binder, EventCollectorResource.class);
            CliEventCollector.bindAnnouncer((Binder)binder, (ServerRunnable.DiscoverySideEffectsProvider)ServerRunnable.DiscoverySideEffectsProvider.create());
            Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
            LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
        });
    }

    private static class CustomJettyServiceInitializer
    implements JettyServerInitializer {
        private static final List<String> UNSECURED_PATHS = List.of("/status/health");
        private final ServerConfig serverConfig;

        @Inject
        public CustomJettyServiceInitializer(ServerConfig serverConfig) {
            this.serverConfig = serverConfig;
        }

        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
            AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
            AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
            AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
            List authenticators = authenticatorMapper.getAuthenticatorChain();
            AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
            JettyServerInitUtils.addAllowHttpMethodsFilter((ServletContextHandler)root, (List)this.serverConfig.getAllowedHttpMethods());
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
            FilterHolder guiceFilterHolder = JettyServerInitUtils.getGuiceFilterHolder((Injector)injector);
            root.addFilter(guiceFilterHolder, "/*", null);
            Handler.Sequence handlerList = new Handler.Sequence(new Handler[0]);
            for (Handler handler : server.getHandlers()) {
                handlerList.addHandler(handler);
            }
            handlerList.addHandler((Handler)JettyServerInitUtils.wrapWithDefaultGzipHandler((ServletContextHandler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel()));
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler((Handler)handlerList);
            server.setHandler((Handler)statisticsHandler);
        }
    }
}

