/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.RetryCapableWorkerManager;
import org.apache.druid.msq.exec.WorkerFailureListener;
import org.apache.druid.msq.exec.WorkerStats;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.indexing.WorkerCount;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.TaskStartTimeoutFault;
import org.apache.druid.msq.indexing.error.TooManyAttemptsForJob;
import org.apache.druid.msq.indexing.error.TooManyAttemptsForWorker;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.rpc.indexing.OverlordClient;

public class MSQWorkerTaskLauncher
implements RetryCapableWorkerManager {
    private static final Logger log = new Logger(MSQWorkerTaskLauncher.class);
    private int currentRelaunchCount = 0;
    private final String controllerTaskId;
    private final String dataSource;
    private final OverlordClient overlordClient;
    private final ExecutorService exec;
    private final long maxTaskStartDelayMillis;
    private final MSQWorkerTaskLauncherConfig config;
    private final SettableFuture<?> stopFuture = SettableFuture.create();
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final AtomicBoolean cancelTasksOnStop = new AtomicBoolean();
    @GuardedBy(value="taskIds")
    private int desiredTaskCount = 0;
    @GuardedBy(value="taskIds")
    private int acknowledgedDesiredTaskCount = 0;
    @GuardedBy(value="taskIds")
    private final List<String> taskIds = new ArrayList<String>();
    @GuardedBy(value="taskIds")
    private final Map<String, Integer> taskIdToWorkerNumber = new HashMap<String, Integer>();
    @GuardedBy(value="taskIds")
    private final IntSet fullyStartedTasks = new IntOpenHashSet();
    private final ConcurrentHashMap<String, TaskTracker> taskTrackers = new ConcurrentHashMap();
    private final Set<String> canceledWorkerTasks = ConcurrentHashMap.newKeySet();
    private final Map<String, Object> taskContextOverrides;
    private final Set<String> tasksToCleanup = ConcurrentHashMap.newKeySet();
    private final Set<Integer> workersToRelaunch = ConcurrentHashMap.newKeySet();
    @GuardedBy(value="taskIds")
    private final Set<Integer> failedInactiveWorkers = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<Integer, List<String>> workerToTaskIds = new ConcurrentHashMap();
    private final WorkerFailureListener workerFailureListener;
    private final AtomicLong recentFullyStartedWorkerTimeInMillis = new AtomicLong(System.currentTimeMillis());
    private final long taskIdsLockTimeout;

    public MSQWorkerTaskLauncher(String controllerTaskId, String dataSource, OverlordClient overlordClient, WorkerFailureListener workerFailureListener, Map<String, Object> taskContextOverrides, long maxTaskStartDelayMillis, MSQWorkerTaskLauncherConfig config) {
        this(controllerTaskId, dataSource, overlordClient, workerFailureListener, taskContextOverrides, maxTaskStartDelayMillis, config, TimeUnit.SECONDS.toMillis(60L));
    }

    @VisibleForTesting
    protected MSQWorkerTaskLauncher(String controllerTaskId, String dataSource, OverlordClient overlordClient, WorkerFailureListener workerFailureListener, Map<String, Object> taskContextOverrides, long maxTaskStartDelayMillis, MSQWorkerTaskLauncherConfig config, long taskIdsLockTimeout) {
        this.controllerTaskId = controllerTaskId;
        this.dataSource = dataSource;
        this.overlordClient = overlordClient;
        this.workerFailureListener = workerFailureListener;
        this.taskContextOverrides = taskContextOverrides;
        this.exec = Execs.singleThreaded((String)("multi-stage-query-task-launcher[" + StringUtils.encodeForFormat((String)controllerTaskId) + "]-%s"));
        this.maxTaskStartDelayMillis = maxTaskStartDelayMillis;
        this.config = config;
        this.taskIdsLockTimeout = taskIdsLockTimeout;
    }

    @Override
    public ListenableFuture<?> start() {
        if (this.state.compareAndSet(State.NEW, State.STARTED)) {
            this.exec.submit(() -> {
                try {
                    this.mainLoop();
                }
                catch (Throwable e) {
                    log.warn(e, "Error encountered in main loop. Abandoning worker tasks.", new Object[0]);
                }
            });
        }
        return this.stopFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean interrupt) {
        if (this.state.compareAndSet(State.NEW, State.STOPPED)) {
            this.state.set(State.STOPPED);
            if (interrupt) {
                this.cancelTasksOnStop.set(true);
            }
            List<String> list = this.taskIds;
            synchronized (list) {
                this.taskIds.notifyAll();
            }
            this.exec.shutdown();
            this.stopFuture.set(null);
        } else if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            if (interrupt) {
                this.cancelTasksOnStop.set(true);
            }
            List<String> list = this.taskIds;
            synchronized (list) {
                this.taskIds.notifyAll();
            }
            this.exec.shutdown();
        } else if (this.state.get() == State.STOPPED) {
            if (interrupt) {
                this.cancelTasksOnStop.set(true);
            }
        } else {
            throw new ISE("Cannot stop(%s) from state [%s]", new Object[]{interrupt, this.state.get()});
        }
        try {
            FutureUtils.getUnchecked(this.stopFuture, (boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkerIds() {
        List<String> list = this.taskIds;
        synchronized (list) {
            return ImmutableList.copyOf(this.taskIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IntObjectPair<MSQFault>> launchWorkersIfNeeded(int workerCount) throws InterruptedException {
        HashSet<IntObjectPair<MSQFault>> failedWorkers = new HashSet<IntObjectPair<MSQFault>>();
        List<String> list = this.taskIds;
        synchronized (list) {
            this.retryInactiveTasksIfNeeded(workerCount);
            if (workerCount > this.desiredTaskCount) {
                this.desiredTaskCount = workerCount;
                this.taskIds.notifyAll();
            }
            while (this.taskIds.size() < workerCount || !this.allTasksStarted(workerCount)) {
                if (this.stopFuture.isDone() || this.stopFuture.isCancelled()) {
                    FutureUtils.getUnchecked(this.stopFuture, (boolean)false);
                    throw new ISE("Stopped", new Object[0]);
                }
                for (TaskTracker taskTracker : this.taskTrackers.values()) {
                    if (!taskTracker.isRetryCandidate()) continue;
                    failedWorkers.add((IntObjectPair<MSQFault>)IntObjectPair.of((int)taskTracker.getWorkerNumber(), (Object)this.generateFailureFault(taskTracker.msqWorkerTask.getId(), taskTracker.statusRef.get())));
                }
                if (!failedWorkers.isEmpty()) {
                    return failedWorkers;
                }
                this.taskIds.wait(this.taskIdsLockTimeout);
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryInactiveTasksIfNeeded(int taskCount) {
        List<String> list = this.taskIds;
        synchronized (list) {
            Iterator<Integer> iterator = this.failedInactiveWorkers.iterator();
            while (iterator.hasNext()) {
                Integer workerNumber = iterator.next();
                if (workerNumber >= taskCount) continue;
                this.submitForRelaunch(workerNumber);
                iterator.remove();
            }
        }
    }

    Set<Integer> getWorkersToRelaunch() {
        return this.workersToRelaunch;
    }

    @Override
    public void submitForRelaunch(int workerNumber) {
        this.workersToRelaunch.add(workerNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedInactiveWorker(int workerNumber) {
        List<String> list = this.taskIds;
        synchronized (list) {
            this.failedInactiveWorkers.add(workerNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IntObjectPair<MSQFault>> waitForWorkers(Set<Integer> workerNumbers) throws InterruptedException {
        HashSet<IntObjectPair<MSQFault>> failedWorkers = new HashSet<IntObjectPair<MSQFault>>();
        List<String> list = this.taskIds;
        synchronized (list) {
            while (!this.fullyStartedTasks.containsAll(workerNumbers)) {
                if (this.stopFuture.isDone() || this.stopFuture.isCancelled()) {
                    FutureUtils.getUnchecked(this.stopFuture, (boolean)false);
                    throw new ISE("Stopped", new Object[0]);
                }
                for (TaskTracker taskTracker : this.taskTrackers.values()) {
                    if (!taskTracker.isRetryCandidate() || !workerNumbers.contains(taskTracker.getWorkerNumber())) continue;
                    failedWorkers.add((IntObjectPair<MSQFault>)IntObjectPair.of((int)taskTracker.getWorkerNumber(), (Object)this.generateFailureFault(taskTracker.msqWorkerTask.getId(), taskTracker.statusRef.get())));
                }
                if (!failedWorkers.isEmpty()) {
                    return failedWorkers;
                }
                this.taskIds.wait(this.taskIdsLockTimeout);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isTaskCanceledByController(String taskId) {
        return this.canceledWorkerTasks.contains(taskId);
    }

    @Override
    public int getWorkerNumber(String taskId) {
        return MSQTasks.workerFromTaskId(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWorkerActive(String taskId) {
        List<String> list = this.taskIds;
        synchronized (list) {
            return this.taskIdToWorkerNumber.get(taskId) != null;
        }
    }

    @Override
    public Map<Integer, List<WorkerStats>> getWorkerStats() {
        Int2ObjectAVLTreeMap workerStats = new Int2ObjectAVLTreeMap();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackers.entrySet()) {
            TaskTracker taskTracker = taskEntry.getValue();
            TaskStatus taskStatus = taskTracker.statusRef.get();
            TaskState statusCode = taskStatus != null ? taskStatus.getStatusCode() : null;
            long duration = taskStatus != null ? taskStatus.getDuration() : -1L;
            ((List)workerStats.computeIfAbsent(taskTracker.workerNumber, k -> new ArrayList())).add(new WorkerStats(taskEntry.getKey(), statusCode, duration, taskTracker.taskPendingTimeInMs()));
        }
        for (List workerStatsList : workerStats.values()) {
            workerStatsList.sort(Comparator.comparing(WorkerStats::getWorkerId));
        }
        return workerStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        block14: {
            try {
                Throwable caught = null;
                while (this.state.get() == State.STARTED) {
                    long loopStartTime = System.currentTimeMillis();
                    try {
                        this.runNewTasks();
                        this.updateTaskTrackersAndTaskIds();
                        this.checkForErroneousTasks();
                        this.relaunchTasks();
                        this.cleanFailedTasksWhichAreRelaunched();
                    }
                    catch (Throwable e) {
                        log.warn(e, "Stopped due to exception in task management loop.", new Object[0]);
                        this.state.set(State.STOPPED);
                        this.cancelTasksOnStop.set(true);
                        caught = e;
                        break;
                    }
                    this.sleep(this.computeSleepTime(System.currentTimeMillis() - loopStartTime), false);
                }
                assert (this.state.get() == State.STOPPED);
                long stopStartTime = System.currentTimeMillis();
                while (this.taskTrackers.values().stream().anyMatch(tracker -> !tracker.isComplete())) {
                    long loopStartTime = System.currentTimeMillis();
                    if (this.cancelTasksOnStop.get()) {
                        this.shutDownTasks();
                    }
                    this.updateTaskTrackersAndTaskIds();
                    long now = System.currentTimeMillis();
                    if (now > stopStartTime + this.config.shutdownTimeoutMillis) {
                        if (caught != null) {
                            throw caught;
                        }
                        throw new ISE("Task shutdown timed out (limit = %,dms)", new Object[]{this.config.shutdownTimeoutMillis});
                    }
                    this.sleep(this.computeSleepTime(now - loopStartTime), true);
                }
                if (caught != null) {
                    throw caught;
                }
                this.stopFuture.set(null);
            }
            catch (Throwable e) {
                if (this.stopFuture.isDone()) break block14;
                this.stopFuture.setException(e);
            }
        }
        List<String> list = this.taskIds;
        synchronized (list) {
            this.taskIds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNewTasks() {
        int taskCount;
        HashMap<String, Object> taskContext = new HashMap<String, Object>();
        for (Map.Entry<String, Object> taskContextOverride : this.taskContextOverrides.entrySet()) {
            if (taskContextOverride.getKey() == null || taskContextOverride.getValue() == null) continue;
            taskContext.put(taskContextOverride.getKey(), taskContextOverride.getValue());
        }
        List<String> list = this.taskIds;
        synchronized (list) {
            int firstTask = this.taskIds.size();
            taskCount = this.desiredTaskCount;
            this.acknowledgedDesiredTaskCount = this.desiredTaskCount;
        }
        for (int i = firstTask; i < taskCount; ++i) {
            MSQWorkerTask task = new MSQWorkerTask(this.controllerTaskId, this.dataSource, i, taskContext, 0);
            this.taskTrackers.put(task.getId(), new TaskTracker(i, task));
            this.workerToTaskIds.computeIfAbsent(i, unused -> new ArrayList()).add(task.getId());
            FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(task.getId(), (Object)task), (boolean)true);
            List<String> list2 = this.taskIds;
            synchronized (list2) {
                this.taskIdToWorkerNumber.put(task.getId(), this.taskIds.size());
                this.taskIds.add(task.getId());
                this.taskIds.notifyAll();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkerCount getWorkerCount() {
        List<String> list = this.taskIds;
        synchronized (list) {
            if (this.stopFuture.isDone()) {
                return new WorkerCount(0, 0);
            }
            int runningTasks = this.fullyStartedTasks.size();
            int pendingTasks = this.desiredTaskCount - runningTasks;
            return new WorkerCount(runningTasks, pendingTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskTrackersAndTaskIds() {
        HashSet<String> taskStatusesNeeded = new HashSet<String>();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackers.entrySet()) {
            if (taskEntry.getValue().isComplete()) continue;
            taskStatusesNeeded.add(taskEntry.getKey());
        }
        if (!taskStatusesNeeded.isEmpty()) {
            Map statuses = (Map)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatuses(taskStatusesNeeded), (boolean)true);
            for (Map.Entry statusEntry : statuses.entrySet()) {
                String taskId = (String)statusEntry.getKey();
                TaskTracker tracker = this.taskTrackers.get(taskId);
                tracker.updateStatus((TaskStatus)statusEntry.getValue());
                TaskStatus status = tracker.statusRef.get();
                if (!status.getStatusCode().isComplete() && tracker.unknownLocation()) {
                    TaskStatusResponse taskStatusResponse = (TaskStatusResponse)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatus(taskId), (boolean)true);
                    if (taskStatusResponse.getStatus() != null) {
                        tracker.setLocation(taskStatusResponse.getStatus().getLocation());
                    } else {
                        tracker.setLocation(TaskLocation.unknown());
                    }
                }
                if (status.getStatusCode() != TaskState.RUNNING || tracker.unknownLocation()) continue;
                List<String> list = this.taskIds;
                synchronized (list) {
                    if (this.fullyStartedTasks.add(tracker.workerNumber)) {
                        this.recentFullyStartedWorkerTimeInMillis.set(System.currentTimeMillis());
                        tracker.setFullyStartedTime(System.currentTimeMillis());
                    }
                    this.taskIds.notifyAll();
                }
            }
        }
    }

    private void checkForErroneousTasks() {
        int numTasks = this.taskTrackers.size();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackersByWorkerNumber()) {
            String taskId = taskEntry.getKey();
            TaskTracker tracker = taskEntry.getValue();
            if (tracker.isRetryCandidate()) continue;
            if (tracker.statusRef.get() != null && tracker.didRunTimeOut(this.maxTaskStartDelayMillis) && !this.canceledWorkerTasks.contains(taskId)) {
                this.removeWorkerFromFullyStartedWorkers(tracker);
                throw new MSQException(new TaskStartTimeoutFault(this.getWorkerCount().getPendingWorkerCount(), numTasks + 1, this.maxTaskStartDelayMillis));
            }
            if (tracker.statusRef.get() != null && (!tracker.didFail() || this.canceledWorkerTasks.contains(taskId))) continue;
            this.startRetryingTasksIfNeeded(tracker, taskId);
        }
    }

    private void startRetryingTasksIfNeeded(TaskTracker tracker, String taskId) {
        tracker.enableRetry();
        this.removeWorkerFromFullyStartedWorkers(tracker);
        MSQFault msqFault = this.generateFailureFault(taskId, tracker.statusRef.get());
        log.info("Task[%s] failed caused of [%s]. Trying to relaunch the worker", new Object[]{taskId, msqFault});
        this.invokeFailureListener(tracker, msqFault);
    }

    private MSQFault generateFailureFault(String taskId, TaskStatus taskStatus) {
        if (taskStatus == null) {
            String errorMessage = StringUtils.format((String)"Task [%s] status missing", (Object[])new Object[]{taskId});
            return UnknownFault.forMessage(errorMessage);
        }
        return new WorkerFailedFault(taskId, taskStatus.getErrorMsg());
    }

    private void invokeFailureListener(TaskTracker tracker, MSQFault msqFault) {
        if (this.workerFailureListener != null) {
            this.workerFailureListener.onFailure(tracker.msqWorkerTask, msqFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWorkerFromFullyStartedWorkers(TaskTracker tracker) {
        List<String> list = this.taskIds;
        synchronized (list) {
            this.fullyStartedTasks.remove(tracker.msqWorkerTask.getWorkerNumber());
            this.taskIds.notifyAll();
        }
    }

    private void relaunchTasks() {
        Iterator<Integer> iterator = this.workersToRelaunch.iterator();
        while (iterator.hasNext()) {
            int worker = iterator.next();
            this.workerToTaskIds.compute(worker, (workerId, taskHistory) -> {
                if (taskHistory == null || taskHistory.isEmpty()) {
                    throw new ISE("TaskHistory cannot by null for worker %d", new Object[]{workerId});
                }
                String latestTaskId = (String)taskHistory.get(taskHistory.size() - 1);
                TaskTracker tracker = this.taskTrackers.get(latestTaskId);
                if (tracker == null) {
                    throw new ISE("Did not find taskTracker for latest taskId[%s]", new Object[]{latestTaskId});
                }
                if (!tracker.isComplete()) {
                    log.info("Did not relaunch worker[%d] with task id[%s] because the task is still running", new Object[]{tracker.workerNumber, latestTaskId});
                    return taskHistory;
                }
                MSQWorkerTask toRelaunch = tracker.msqWorkerTask;
                MSQWorkerTask relaunchedTask = toRelaunch.getRetryTask();
                this.checkRelaunchLimitsOrThrow(tracker, toRelaunch);
                this.tasksToCleanup.add(latestTaskId);
                this.taskTrackers.remove(latestTaskId);
                log.info("Relaunching worker[%d] with new task id[%s] with worker relaunch count[%d] and job relaunch count[%d]", new Object[]{relaunchedTask.getWorkerNumber(), relaunchedTask.getId(), toRelaunch.getRetryCount(), this.currentRelaunchCount});
                ++this.currentRelaunchCount;
                this.taskTrackers.put(relaunchedTask.getId(), new TaskTracker(relaunchedTask.getWorkerNumber(), relaunchedTask));
                List<String> list = this.taskIds;
                synchronized (list) {
                    this.fullyStartedTasks.remove(relaunchedTask.getWorkerNumber());
                    this.taskIds.notifyAll();
                }
                FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(relaunchedTask.getId(), (Object)relaunchedTask), (boolean)true);
                taskHistory.add(relaunchedTask.getId());
                list = this.taskIds;
                synchronized (list) {
                    this.taskIdToWorkerNumber.remove(this.taskIds.get(toRelaunch.getWorkerNumber()));
                    this.taskIds.set(toRelaunch.getWorkerNumber(), relaunchedTask.getId());
                    this.taskIdToWorkerNumber.put(relaunchedTask.getId(), toRelaunch.getWorkerNumber());
                    this.taskIds.notifyAll();
                }
                return taskHistory;
            });
            iterator.remove();
        }
    }

    private void checkRelaunchLimitsOrThrow(TaskTracker tracker, MSQWorkerTask relaunchTask) {
        if (relaunchTask.getRetryCount() > 2) {
            throw new MSQException(new TooManyAttemptsForWorker(2, relaunchTask.getId(), relaunchTask.getWorkerNumber(), tracker.statusRef.get().getErrorMsg()));
        }
        if (this.currentRelaunchCount > 100) {
            throw new MSQException(new TooManyAttemptsForJob(100, this.currentRelaunchCount, relaunchTask.getId(), tracker.statusRef.get().getErrorMsg()));
        }
    }

    private void shutDownTasks() {
        this.cleanFailedTasksWhichAreRelaunched();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackersByWorkerNumber()) {
            String taskId = taskEntry.getKey();
            TaskTracker tracker = taskEntry.getValue();
            if (this.canceledWorkerTasks.contains(taskId) || tracker.isComplete()) continue;
            this.canceledWorkerTasks.add(taskId);
            FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.cancelTask(taskId), (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanFailedTasksWhichAreRelaunched() {
        Iterator<String> tasksToCancel = this.tasksToCleanup.iterator();
        while (tasksToCancel.hasNext()) {
            String taskId = tasksToCancel.next();
            try {
                if (!this.canceledWorkerTasks.add(taskId)) continue;
                try {
                    FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.cancelTask(taskId), (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                tasksToCancel.remove();
            }
        }
    }

    @GuardedBy(value="taskIds")
    private boolean allTasksStarted(int taskCount) {
        for (int i = 0; i < taskCount; ++i) {
            if (this.fullyStartedTasks.contains(i)) continue;
            return false;
        }
        return true;
    }

    private List<Map.Entry<String, TaskTracker>> taskTrackersByWorkerNumber() {
        return this.taskTrackers.entrySet().stream().sorted(Comparator.comparing(entry -> ((TaskTracker)entry.getValue()).workerNumber)).collect(Collectors.toList());
    }

    private long computeSleepTime(long loopDurationMillis) {
        OptionalLong maxTaskStartTime = this.taskTrackers.values().stream().mapToLong(tracker -> tracker.startTimeMillis).max();
        if (maxTaskStartTime.isPresent() && System.currentTimeMillis() - maxTaskStartTime.getAsLong() < this.config.switchToLowFrequencyCheckAfterMillis) {
            return this.config.highFrequencyCheckMillis - loopDurationMillis;
        }
        return this.config.lowFrequencyCheckMillis - loopDurationMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long sleepMillis, boolean shuttingDown) throws InterruptedException {
        if (sleepMillis > 0L) {
            if (shuttingDown) {
                Thread.sleep(sleepMillis);
            } else {
                List<String> list = this.taskIds;
                synchronized (list) {
                    if (this.acknowledgedDesiredTaskCount == this.desiredTaskCount) {
                        this.taskIds.wait(sleepMillis);
                    }
                }
            }
        } else if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static class MSQWorkerTaskLauncherConfig {
        public long highFrequencyCheckMillis = 100L;
        public long lowFrequencyCheckMillis = 2000L;
        public long switchToLowFrequencyCheckAfterMillis = 10000L;
        public long shutdownTimeoutMillis = Duration.ofMinutes(1L).toMillis();
    }

    private static enum State {
        NEW,
        STARTED,
        STOPPED;

    }

    private class TaskTracker {
        private final int workerNumber;
        private final long startTimeMillis = System.currentTimeMillis();
        private final AtomicLong taskFullyStartedTimeRef = new AtomicLong();
        private final MSQWorkerTask msqWorkerTask;
        private final AtomicReference<TaskStatus> statusRef = new AtomicReference();
        private final AtomicReference<TaskLocation> initialLocationRef = new AtomicReference();
        private final AtomicBoolean isRetryingRef = new AtomicBoolean(false);

        public TaskTracker(int workerNumber, MSQWorkerTask msqWorkerTask) {
            this.workerNumber = workerNumber;
            this.msqWorkerTask = msqWorkerTask;
        }

        public boolean unknownLocation() {
            TaskLocation initialLocation = this.initialLocationRef.get();
            return initialLocation == null || TaskLocation.unknown().equals((Object)initialLocation);
        }

        public boolean isComplete() {
            TaskStatus status = this.statusRef.get();
            return status != null && status.getStatusCode().isComplete();
        }

        public boolean didFail() {
            TaskStatus status = this.statusRef.get();
            return status != null && status.getStatusCode().isFailure();
        }

        public boolean didRunTimeOut(long maxTaskStartDelayMillis) {
            long currentTimeMillis = System.currentTimeMillis();
            TaskStatus status = this.statusRef.get();
            return (status == null || status.getStatusCode() == TaskState.RUNNING) && this.unknownLocation() && currentTimeMillis - MSQWorkerTaskLauncher.this.recentFullyStartedWorkerTimeInMillis.get() > maxTaskStartDelayMillis && currentTimeMillis - this.startTimeMillis > maxTaskStartDelayMillis;
        }

        public void enableRetry() {
            this.isRetryingRef.set(true);
        }

        public boolean isRetryCandidate() {
            return this.isRetryingRef.get();
        }

        public void setLocation(TaskLocation taskLocation) {
            this.initialLocationRef.set(taskLocation);
        }

        public void updateStatus(TaskStatus taskStatus) {
            this.statusRef.set(taskStatus);
        }

        public void setFullyStartedTime(long currentTimeMillis) {
            this.taskFullyStartedTimeRef.set(currentTimeMillis);
        }

        public long taskPendingTimeInMs() {
            long currentFullyStartingTime = this.taskFullyStartedTimeRef.get();
            if (currentFullyStartingTime == 0L) {
                return System.currentTimeMillis() - this.startTimeMillis;
            }
            return Math.max(0L, currentFullyStartingTime - this.startTimeMillis);
        }

        public int getWorkerNumber() {
            return this.workerNumber;
        }
    }
}

