/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.actionstate;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.InputEvent;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.runtime.python.event.PythonEvent;
import org.apache.flink.shaded.guava31.com.google.common.base.Preconditions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class ActionStateUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String KEY_SEPARATOR = "_";

    public static String generateKey(@Nonnull Object key, long seqNum, @Nonnull Action action, @Nonnull Event event) throws IOException {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null.");
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null.");
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null.");
        return String.join((CharSequence)KEY_SEPARATOR, key.toString(), String.valueOf(seqNum), ActionStateUtil.generateUUIDForEvent(event), ActionStateUtil.generateUUIDForAction(action));
    }

    public static List<String> parseKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null.");
        String[] parts = key.split(KEY_SEPARATOR);
        Preconditions.checkArgument((parts.length == 4 ? 1 : 0) != 0, (Object)"Invalid key format.");
        return List.of(parts);
    }

    private static String generateUUIDForEvent(Event event) throws IOException {
        if (event instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)event;
            byte[] inputEventBytes = MAPPER.writeValueAsBytes(new Object[]{inputEvent.getInput(), inputEvent.getAttributes()});
            return String.valueOf(UUID.nameUUIDFromBytes(inputEventBytes));
        }
        if (event instanceof PythonEvent) {
            PythonEvent pythonEvent = (PythonEvent)event;
            byte[] pythonEventBytes = MAPPER.writeValueAsBytes(new Object[]{pythonEvent.getEvent(), pythonEvent.getEventType(), pythonEvent.getAttributes()});
            return String.valueOf(UUID.nameUUIDFromBytes(pythonEventBytes));
        }
        return String.valueOf(UUID.nameUUIDFromBytes(event.getAttributes().toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static String generateUUIDForAction(Action action) throws IOException {
        return String.valueOf(UUID.nameUUIDFromBytes(String.valueOf(action.hashCode()).getBytes(StandardCharsets.UTF_8)));
    }
}

