/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.Collection;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsExportHelper;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsExportHelper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsExportHelper.class);

    @Test
    public void testExportHelper() {
        DefaultMetricsSystem.initialize((String)"exportHelperTestSystem");
        DefaultMetricsSystem.instance().start();
        String metricsName = "exportMetricsTestGrp";
        String gaugeName = "exportMetricsTestGauge";
        String counterName = "exportMetricsTestCounter";
        BaseSourceImpl baseSource = new BaseSourceImpl(metricsName, "", metricsName, metricsName);
        baseSource.setGauge(gaugeName, 0L);
        baseSource.incCounters(counterName, 1L);
        Collection metrics = MetricsExportHelper.export();
        DefaultMetricsSystem.instance().stop();
        Assert.assertTrue((boolean)metrics.stream().anyMatch(mr -> mr.name().equals(metricsName)));
        Assert.assertTrue((String)(gaugeName + " is missing in the export"), (boolean)this.contains(metrics, metricsName, gaugeName));
        Assert.assertTrue((String)(counterName + " is missing in the export"), (boolean)this.contains(metrics, metricsName, counterName));
    }

    private boolean contains(Collection<MetricsRecord> metrics, String metricsName, String metricName) {
        return metrics.stream().filter(mr -> mr.name().equals(metricsName)).anyMatch(mr -> {
            for (AbstractMetric metric : mr.metrics()) {
                if (!metric.name().equals(metricName)) continue;
                return true;
            }
            return false;
        });
    }
}

