/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerValidationUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStoreFileTrackerValidationUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileTrackerValidationUtils.class);

    @Test
    public void testCheckSFTCompatibility() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.store.file-tracker.impl", "DEFAULT");
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"TableX"));
        builder.setValue("hbase.store.file-tracker.impl", "FILE");
        ColumnFamilyDescriptor cf = ColumnFamilyDescriptorBuilder.of((String)"cf");
        builder.setColumnFamily(cf);
        TableDescriptor td = builder.build();
        TableDescriptorBuilder snapBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"TableY"));
        snapBuilder.setValue("hbase.store.file-tracker.impl", "FILE");
        ColumnFamilyDescriptorBuilder snapCFBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf"));
        snapCFBuilder.setValue("hbase.store.file-tracker.impl", "FILE");
        snapBuilder.setColumnFamily(snapCFBuilder.build());
        TableDescriptor snapTd = snapBuilder.build();
        StoreFileTrackerValidationUtils.validatePreRestoreSnapshot((TableDescriptor)td, (TableDescriptor)snapTd, (Configuration)conf);
        StoreFileTrackerValidationUtils.validatePreRestoreSnapshot((TableDescriptor)snapTd, (TableDescriptor)td, (Configuration)conf);
        TableDescriptorBuilder defaultBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"TableY"));
        defaultBuilder.setValue("hbase.store.file-tracker.impl", "FILE");
        ColumnFamilyDescriptorBuilder defaultCFBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf"));
        defaultCFBuilder.setValue("hbase.store.file-tracker.impl", "DEFAULT");
        defaultBuilder.setColumnFamily(defaultCFBuilder.build());
        TableDescriptor defaultTd = defaultBuilder.build();
        Assert.assertThrows(RestoreSnapshotException.class, () -> StoreFileTrackerValidationUtils.validatePreRestoreSnapshot((TableDescriptor)td, (TableDescriptor)defaultTd, (Configuration)conf));
        Assert.assertThrows(RestoreSnapshotException.class, () -> StoreFileTrackerValidationUtils.validatePreRestoreSnapshot((TableDescriptor)snapTd, (TableDescriptor)defaultTd, (Configuration)conf));
    }
}

