/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface WALTailingReader
extends Closeable {
    public Result next(long var1);

    public long getPosition() throws IOException;

    public void resetTo(long var1, boolean var3) throws IOException;

    @Override
    public void close();

    public static final class Result {
        private final State state;
        private final WAL.Entry entry;
        private final long entryEndPos;

        public Result(State state, WAL.Entry entry, long entryEndPos) {
            this.state = state;
            this.entry = entry;
            this.entryEndPos = entryEndPos;
        }

        public State getState() {
            return this.state;
        }

        public WAL.Entry getEntry() {
            return this.entry;
        }

        public long getEntryEndPos() {
            return this.entryEndPos;
        }
    }

    public static enum State {
        NORMAL,
        EOF_WITH_TRAILER,
        ERROR_AND_RESET,
        ERROR_AND_RESET_COMPRESSION,
        EOF_AND_RESET,
        EOF_AND_RESET_COMPRESSION;

        private Result result = new Result(this, null, -1L);

        public Result getResult() {
            return this.result;
        }

        public boolean resetCompression() {
            return this == ERROR_AND_RESET_COMPRESSION || this == EOF_AND_RESET_COMPRESSION;
        }

        public boolean eof() {
            return this == EOF_AND_RESET || this == EOF_AND_RESET_COMPRESSION || this == EOF_WITH_TRAILER;
        }
    }
}

