/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RecoverLeaseFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverLeaseFSUtils.class);
    private static Class<?> leaseRecoverableClazz = null;
    private static Method recoverLeaseMethod = null;
    public static final String LEASE_RECOVERABLE_CLASS_NAME = "org.apache.hadoop.fs.LeaseRecoverable";

    static void initializeRecoverLeaseMethod(String className) {
        try {
            leaseRecoverableClazz = Class.forName(className);
            recoverLeaseMethod = leaseRecoverableClazz.getMethod("recoverLease", Path.class);
            LOG.debug("set recoverLeaseMethod to " + className + ".recoverLease()");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("LeaseRecoverable interface not in the classpath, this means Hadoop 3.3.5 or below.");
            try {
                recoverLeaseMethod = DistributedFileSystem.class.getMethod("recoverLease", Path.class);
            }
            catch (NoSuchMethodException ex) {
                LOG.error("Cannot find recoverLease method in DistributedFileSystem class. It should never happen. Abort.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cannot find recoverLease method in LeaseRecoverable class. It should never happen. Abort.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private RecoverLeaseFSUtils() {
    }

    public static void recoverFileLease(FileSystem fs, Path p, Configuration conf) throws IOException {
        RecoverLeaseFSUtils.recoverFileLease(fs, p, conf, null);
    }

    public static void recoverFileLease(FileSystem fs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        if (fs instanceof FilterFileSystem) {
            fs = ((FilterFileSystem)fs).getRawFileSystem();
        }
        if (RecoverLeaseFSUtils.isLeaseRecoverable(fs)) {
            RecoverLeaseFSUtils.recoverDFSFileLease(fs, p, conf, reporter);
        }
    }

    public static boolean isLeaseRecoverable(FileSystem fs) {
        if (fs instanceof DistributedFileSystem) {
            return true;
        }
        if (leaseRecoverableClazz != null) {
            return leaseRecoverableClazz.isAssignableFrom(fs.getClass());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean recoverDFSFileLease(FileSystem dfs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        LOG.info("Recover lease on dfs file " + p);
        long startWaiting = EnvironmentEdgeManager.currentTime();
        long recoveryTimeout = (long)conf.getInt("hbase.lease.recovery.timeout", 900000) + startWaiting;
        long firstPause = conf.getInt("hbase.lease.recovery.first.pause", 4000);
        long subsequentPauseBase = conf.getLong("hbase.lease.recovery.dfs.timeout", 64000L);
        Method isFileClosedMeth = null;
        boolean findIsFileClosedMeth = true;
        boolean recovered = false;
        int nbAttempt = 0;
        while (!recovered && !(recovered = RecoverLeaseFSUtils.recoverLease(dfs, nbAttempt, p, startWaiting))) {
            block12: {
                RecoverLeaseFSUtils.checkIfCancelled(reporter);
                if (RecoverLeaseFSUtils.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting)) break;
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block12;
                    }
                    long localStartWaiting = EnvironmentEdgeManager.currentTime();
                    while (EnvironmentEdgeManager.currentTime() - localStartWaiting < subsequentPauseBase * (long)nbAttempt) {
                        Thread.sleep(conf.getInt("hbase.lease.recovery.pause", 1000));
                        if (findIsFileClosedMeth) {
                            try {
                                isFileClosedMeth = dfs.getClass().getMethod("isFileClosed", Path.class);
                            }
                            catch (NoSuchMethodException nsme) {
                                LOG.debug("isFileClosed not available");
                            }
                            finally {
                                findIsFileClosedMeth = false;
                            }
                        }
                        if (isFileClosedMeth != null && RecoverLeaseFSUtils.isFileClosed(dfs, isFileClosedMeth, p)) {
                            recovered = true;
                            break;
                        }
                        RecoverLeaseFSUtils.checkIfCancelled(reporter);
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        return recovered;
    }

    private static boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < EnvironmentEdgeManager.currentTime()) {
            LOG.warn("Cannot recoverLease after trying for " + conf.getInt("hbase.lease.recovery.timeout", 900000) + "ms (hbase.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
            return true;
        }
        return false;
    }

    private static boolean recoverLease(FileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = (Boolean)recoverLeaseMethod.invoke((Object)dfs, p);
            LOG.info((recovered ? "Recovered lease, " : "Failed to recover lease, ") + RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getCause();
            if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given WAL wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            LOG.warn(RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting), e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to call recoverLease on {}. Abort.", (Object)dfs, (Object)e);
            throw new RuntimeException(e);
        }
        return recovered;
    }

    private static String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms";
    }

    private static boolean isFileClosed(FileSystem dfs, Method m, Path p) {
        try {
            return (Boolean)m.invoke((Object)dfs, p);
        }
        catch (SecurityException e) {
            LOG.warn("No access", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Failed invocation for " + p.toString(), (Throwable)e);
        }
        return false;
    }

    private static void checkIfCancelled(CancelableProgressable reporter) throws InterruptedIOException {
        if (reporter == null) {
            return;
        }
        if (!reporter.progress()) {
            throw new InterruptedIOException("Operation cancelled");
        }
    }

    static {
        LOG.debug("Initialize RecoverLeaseFSUtils");
        RecoverLeaseFSUtils.initializeRecoverLeaseMethod(LEASE_RECOVERABLE_CLASS_NAME);
    }
}

