/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternMatcher;
import com.google.inject.servlet.UriPatternType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

class FiltersModuleBuilder {
    private final Binder binder;

    public FiltersModuleBuilder(Binder binder) {
        this.binder = binder;
    }

    public ServletModule.FilterKeyBindingBuilder filter(List<String> patterns) {
        return new FilterKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.SERVLET, patterns));
    }

    public ServletModule.FilterKeyBindingBuilder filterRegex(List<String> regexes) {
        return new FilterKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.REGEX, regexes));
    }

    private List<UriPatternMatcher> parsePatterns(UriPatternType type, List<String> patterns) {
        ArrayList<UriPatternMatcher> patternMatchers = new ArrayList<UriPatternMatcher>();
        for (String pattern : patterns) {
            UriPatternMatcher matcher = null;
            try {
                matcher = UriPatternType.get(type, pattern);
            }
            catch (IllegalArgumentException iae) {
                this.binder.skipSources(new Class[]{ServletModule.class, FiltersModuleBuilder.class}).addError("%s", new Object[]{iae.getMessage()});
            }
            if (matcher == null) continue;
            patternMatchers.add(matcher);
        }
        return patternMatchers;
    }

    class FilterKeyBindingBuilderImpl
    implements ServletModule.FilterKeyBindingBuilder {
        private final List<UriPatternMatcher> uriPatterns;

        private FilterKeyBindingBuilderImpl(List<UriPatternMatcher> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(Class<? extends Filter> filterKey) {
            this.through((Key<? extends Filter>)Key.get(filterKey));
        }

        @Override
        public void through(Key<? extends Filter> filterKey) {
            this.through(filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(Filter filter) {
            this.through(filter, new HashMap<String, String>());
        }

        @Override
        public void through(Class<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through((Key<? extends Filter>)Key.get(filterKey), initParams);
        }

        @Override
        public void through(Key<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(filterKey, initParams, null);
        }

        private void through(Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
            for (UriPatternMatcher pattern : this.uriPatterns) {
                FiltersModuleBuilder.this.binder.bind(FilterDefinition.class).annotatedWith(UniqueAnnotations.create()).toProvider((Provider)new FilterDefinition(filterKey, pattern, initParams, filterInstance));
            }
        }

        @Override
        public void through(Filter filter, Map<String, String> initParams) {
            Key filterKey = Key.get(Filter.class, (Annotation)UniqueAnnotations.create());
            FiltersModuleBuilder.this.binder.bind(filterKey).toInstance((Object)filter);
            this.through((Key<? extends Filter>)filterKey, initParams, filter);
        }
    }
}

